/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.protobuf;

import com.google.protobuf.MessageLite;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.util.CollectionUtils;

public class ProtobufHelper {
    ConcurrentMap<Class, Method> parseFromMethodMap = new ConcurrentHashMap<Class, Method>();
    ConcurrentMap<Class, Method> toByteArrayMethodMap = new ConcurrentHashMap<Class, Method>();
    private ConcurrentMap<String, Class> requestClassCache = new ConcurrentHashMap<String, Class>();

    public Class getPbClass(String clazzName) {
        return (Class)CollectionUtils.computeIfAbsent(this.requestClassCache, (Object)clazzName, key -> {
            Class<?> clazz;
            try {
                clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e) {
                throw new ShouldNeverHappenException("get class occurs exception", (Throwable)e);
            }
            if (clazz == Void.TYPE || !this.isProtoBufMessageClass(clazz)) {
                throw new ShouldNeverHappenException("class based protobuf: " + clazz.getName() + ", only support return protobuf message!");
            }
            return clazz;
        });
    }

    boolean isProtoBufMessageClass(Class clazz) {
        return clazz != null && MessageLite.class.isAssignableFrom(clazz);
    }
}

