/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.util.unsafe;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.ProtectionDomain;
import org.apache.fury.annotation.Internal;
import org.apache.fury.memory.Platform;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.unsafe._JDKAccess;
import org.apache.fury.util.unsafe._Lookup;

@Internal
public class DefineClass {
    private static volatile MethodHandle classloaderDefineClassHandle;

    public static Class<?> defineClass(String className, Class<?> neighbor, ClassLoader loader, ProtectionDomain domain, byte[] bytecodes) {
        Preconditions.checkNotNull(loader);
        Preconditions.checkArgument(Platform.JAVA_VERSION >= 8);
        if (neighbor != null && Platform.JAVA_VERSION >= 9) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            _JDKAccess.addReads(_JDKAccess.getModule(DefineClass.class), _JDKAccess.getModule(neighbor));
            lookup = _Lookup.privateLookupIn(neighbor, lookup);
            return _Lookup.defineClass(lookup, bytecodes);
        }
        if (classloaderDefineClassHandle == null) {
            MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(ClassLoader.class);
            try {
                classloaderDefineClassHandle = lookup.findVirtual(ClassLoader.class, "defineClass", MethodType.methodType(Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return (Class)classloaderDefineClassHandle.invokeWithArguments(loader, className, bytecodes, 0, bytecodes.length, domain);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

