/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer.collection;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.fury.Fury;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.Platform;
import org.apache.fury.serializer.collection.CollectionContainer;
import org.apache.fury.serializer.collection.CollectionSerializer;
import org.apache.fury.serializer.collection.MapContainer;
import org.apache.fury.serializer.collection.MapSerializer;
import org.apache.fury.serializer.collection.SortedCollectionContainer;
import org.apache.fury.serializer.collection.SortedMapContainer;
import org.apache.fury.type.Type;
import org.apache.fury.util.unsafe._JDKAccess;

public class GuavaCollectionSerializers {
    private static final String pkg = "com.google.common.collect";
    private static Function regularImmutableListInvokeCache;
    private static final ClassValue<Function> builderCtrCache;

    private static synchronized Function regularImmutableListInvoke() {
        if (regularImmutableListInvokeCache == null) {
            Class<?> cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.RegularImmutableList", ImmutableList.of((Object)1, (Object)2).getClass());
            MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(cls);
            MethodHandle ctr = null;
            try {
                ctr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE, Object[].class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                Platform.throwException(e);
            }
            regularImmutableListInvokeCache = _JDKAccess.makeJDKFunction(lookup, ctr);
        }
        return regularImmutableListInvokeCache;
    }

    public static void registerDefaultSerializers(Fury fury) {
        Class<Object> cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.RegularImmutableBiMap", ImmutableBiMap.of((Object)"k1", (Object)1, (Object)"k2", (Object)4).getClass());
        fury.registerSerializer(cls, new ImmutableBiMapSerializer(fury, cls));
        cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.SingletonImmutableBiMap", ImmutableBiMap.of((Object)1, (Object)2).getClass());
        fury.registerSerializer(cls, new ImmutableBiMapSerializer(fury, cls));
        cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.RegularImmutableMap", ImmutableMap.of((Object)"k1", (Object)1, (Object)"k2", (Object)2).getClass());
        fury.registerSerializer(cls, new ImmutableMapSerializer(fury, cls));
        cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.RegularImmutableList", ImmutableList.of().getClass());
        fury.registerSerializer(cls, new RegularImmutableListSerializer(fury, cls));
        cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.SingletonImmutableList", ImmutableList.of((Object)1).getClass());
        fury.registerSerializer(cls, new ImmutableListSerializer(fury, cls));
        cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.RegularImmutableSet", ImmutableSet.of((Object)1, (Object)2).getClass());
        fury.registerSerializer(cls, new ImmutableSetSerializer(fury, cls));
        cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.SingletonImmutableSet", ImmutableSet.of((Object)1).getClass());
        fury.registerSerializer(cls, new ImmutableSetSerializer(fury, cls));
        cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.RegularImmutableSortedSet", ImmutableSortedSet.of((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)).getClass());
        fury.registerSerializer(cls, new ImmutableSortedSetSerializer(fury, cls));
        cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.ImmutableSortedMap", ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)2).getClass());
        fury.registerSerializer(cls, new ImmutableSortedMapSerializer(fury, cls));
        if (GuavaCollectionSerializers.checkClassExist("com.google.common.collect.EmptyImmutableSet")) {
            cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.EmptyImmutableSet", ImmutableSet.of().getClass());
            fury.registerSerializer(cls, new ImmutableSetSerializer(fury, cls));
        } else {
            class GuavaEmptySet {
                GuavaEmptySet() {
                }
            }
            cls = GuavaEmptySet.class;
            fury.registerSerializer(cls, new ImmutableSetSerializer(fury, cls));
        }
        if (GuavaCollectionSerializers.checkClassExist("com.google.common.collect.EmptyImmutableBiMap")) {
            cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.EmptyImmutableBiMap", ImmutableBiMap.of().getClass());
            fury.registerSerializer(cls, new ImmutableMapSerializer(fury, cls));
        } else {
            class GuavaEmptyBiMap {
                GuavaEmptyBiMap() {
                }
            }
            cls = GuavaEmptyBiMap.class;
            fury.registerSerializer(cls, new ImmutableMapSerializer(fury, cls));
        }
        if (GuavaCollectionSerializers.checkClassExist("com.google.common.collect.EmptyImmutableSortedSet")) {
            cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.EmptyImmutableSortedSet", ImmutableSortedSet.of().getClass());
            fury.registerSerializer(cls, new ImmutableSortedSetSerializer(fury, cls));
        } else {
            class GuavaEmptySortedSet {
                GuavaEmptySortedSet() {
                }
            }
            cls = GuavaEmptySortedSet.class;
            fury.registerSerializer(cls, new ImmutableSortedSetSerializer(fury, cls));
        }
        if (GuavaCollectionSerializers.checkClassExist("com.google.common.collect.EmptyImmutableSortedMap")) {
            cls = GuavaCollectionSerializers.loadClass("com.google.common.collect.EmptyImmutableSortedMap", ImmutableSortedMap.of().getClass());
            fury.registerSerializer(cls, new ImmutableSortedMapSerializer(fury, cls));
        } else {
            class GuavaEmptySortedMap {
                GuavaEmptySortedMap() {
                }
            }
            cls = GuavaEmptySortedMap.class;
            fury.registerSerializer(cls, new ImmutableSortedMapSerializer(fury, cls));
        }
    }

    static Class<?> loadClass(String className, Class<?> cache) {
        if (cache.getName().equals(className)) {
            return cache;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean checkClassExist(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    static /* synthetic */ Function access$000() {
        return GuavaCollectionSerializers.regularImmutableListInvoke();
    }

    static /* synthetic */ ClassValue access$100() {
        return builderCtrCache;
    }

    static {
        builderCtrCache = new ClassValue<Function>(){

            @Override
            protected Function computeValue(Class<?> builderClass) {
                MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(builderClass);
                MethodHandle ctr = null;
                boolean lowVersionGuava = false;
                try {
                    ctr = lookup.findConstructor(builderClass, MethodType.methodType(Void.TYPE, Integer.TYPE));
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    try {
                        ctr = lookup.findConstructor(builderClass, MethodType.methodType(Void.TYPE));
                        lowVersionGuava = true;
                    }
                    catch (IllegalAccessException | NoSuchMethodException e2) {
                        Platform.throwException(e);
                    }
                }
                if (lowVersionGuava) {
                    return _JDKAccess.makeJDKFunction(lookup, ctr, MethodType.methodType(Object.class));
                }
                return _JDKAccess.makeJDKFunction(lookup, ctr);
            }
        };
    }

    public static final class ImmutableSortedMapSerializer<T extends ImmutableSortedMap>
    extends MapSerializer<T> {
        public ImmutableSortedMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public Map onMapWrite(MemoryBuffer buffer, T value) {
            buffer.writeVarUint32Small7(value.size());
            this.fury.writeRef(buffer, value.comparator());
            return value;
        }

        @Override
        public Map newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            return new SortedMapContainer(comparator, numElements);
        }

        @Override
        public T copy(T originMap) {
            Comparator comparator = this.fury.copyObject(originMap.comparator());
            ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(comparator);
            this.copyEntry(originMap, builder);
            return (T)builder.build();
        }

        @Override
        public T onMapRead(Map map) {
            SortedMapContainer mapContainer = (SortedMapContainer)map;
            ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(mapContainer.comparator);
            int size = mapContainer.size;
            Object[] keyArray = mapContainer.keyArray;
            Object[] valueArray = mapContainer.valueArray;
            for (int i = 0; i < size; ++i) {
                builder.put(keyArray[i], valueArray[i]);
            }
            return (T)((ImmutableSortedMap)builder.build());
        }
    }

    public static final class ImmutableBiMapSerializer<T extends ImmutableBiMap>
    extends GuavaMapSerializer<T> {
        private final Function<Integer, ImmutableBiMap.Builder> builderCtr = (Function)GuavaCollectionSerializers.access$100().get(ImmutableBiMap.Builder.class);

        public ImmutableBiMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        protected ImmutableMap.Builder makeBuilder(int size) {
            return (ImmutableMap.Builder)this.builderCtr.apply(size);
        }

        @Override
        protected T xnewInstance(Map map) {
            return (T)ImmutableBiMap.copyOf((Map)map);
        }
    }

    public static final class ImmutableMapSerializer<T extends ImmutableMap>
    extends GuavaMapSerializer<T> {
        private final Function<Integer, ImmutableMap.Builder> builderCtr = (Function)GuavaCollectionSerializers.access$100().get(ImmutableMap.Builder.class);

        public ImmutableMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        protected ImmutableMap.Builder makeBuilder(int size) {
            return this.builderCtr.apply(size);
        }

        @Override
        protected T xnewInstance(Map map) {
            return (T)ImmutableMap.copyOf((Map)map);
        }
    }

    static abstract class GuavaMapSerializer<T extends Map>
    extends MapSerializer<T> {
        public GuavaMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, true);
            fury.getClassResolver().setSerializer(cls, this);
        }

        protected abstract ImmutableMap.Builder makeBuilder(int var1);

        @Override
        public Map newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            return new MapContainer(numElements);
        }

        @Override
        public T copy(T originMap) {
            ImmutableMap.Builder builder = this.makeBuilder(originMap.size());
            this.copyEntry(originMap, builder);
            return (T)builder.build();
        }

        @Override
        public T onMapRead(Map map) {
            MapContainer container = (MapContainer)map;
            int size = container.size;
            ImmutableMap.Builder builder = this.makeBuilder(size);
            Object[] keyArray = container.keyArray;
            Object[] valueArray = container.valueArray;
            for (int i = 0; i < size; ++i) {
                builder.put(keyArray[i], valueArray[i]);
            }
            return (T)builder.build();
        }

        @Override
        public short getXtypeId() {
            return -Type.MAP.getId();
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            int size = buffer.readVarUint32Small7();
            HashMap map = new HashMap();
            GuavaMapSerializer.xreadElements(this.fury, buffer, map, size);
            return this.xnewInstance(map);
        }

        protected abstract T xnewInstance(Map var1);
    }

    public static final class ImmutableSortedSetSerializer<T extends ImmutableSortedSet>
    extends CollectionSerializer<T> {
        public ImmutableSortedSetSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, T value) {
            buffer.writeVarUint32Small7(value.size());
            this.fury.writeRef(buffer, value.comparator());
            return value;
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            return new SortedCollectionContainer(comparator, numElements);
        }

        @Override
        public T onCollectionRead(Collection collection) {
            SortedCollectionContainer data = (SortedCollectionContainer)collection;
            Object[] elements = data.elements;
            return (T)new ImmutableSortedSet.Builder(data.comparator).add(elements).build();
        }

        @Override
        public T copy(T originCollection) {
            Comparator comparator = this.fury.copyObject(originCollection.comparator());
            Object[] elements = new Object[originCollection.size()];
            this.copyElements((Collection)originCollection, elements);
            return (T)new ImmutableSortedSet.Builder(comparator).add(elements).build();
        }
    }

    public static final class ImmutableSetSerializer<T extends ImmutableSet>
    extends GuavaCollectionSerializer<T> {
        public ImmutableSetSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            return new CollectionContainer(numElements);
        }

        @Override
        public T onCollectionRead(Collection collection) {
            Object[] elements = ((CollectionContainer)collection).elements;
            return (T)ImmutableSet.copyOf((Object[])elements);
        }

        @Override
        public short getXtypeId() {
            return -Type.FURY_SET.getId();
        }

        @Override
        protected T xnewInstance(Collection collection) {
            return (T)ImmutableSet.copyOf((Collection)collection);
        }

        @Override
        public T copy(T originCollection) {
            Object[] elements = new Object[originCollection.size()];
            this.copyElements((Collection)originCollection, elements);
            return (T)ImmutableSet.copyOf((Object[])elements);
        }
    }

    public static final class RegularImmutableListSerializer<T extends ImmutableList>
    extends GuavaCollectionSerializer<T> {
        private final Function<Object[], ImmutableList> function = GuavaCollectionSerializers.access$000();

        public RegularImmutableListSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            return new CollectionContainer(numElements);
        }

        @Override
        public T onCollectionRead(Collection collection) {
            Object[] elements = ((CollectionContainer)collection).elements;
            return (T)this.function.apply(elements);
        }

        @Override
        public T copy(T originCollection) {
            Object[] elements = new Object[originCollection.size()];
            this.copyElements((Collection)originCollection, elements);
            return (T)this.function.apply(elements);
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        protected T xnewInstance(Collection collection) {
            return (T)ImmutableList.copyOf((Collection)collection);
        }
    }

    public static final class ImmutableListSerializer<T extends ImmutableList>
    extends GuavaCollectionSerializer<T> {
        public ImmutableListSerializer(Fury fury, Class<T> cls) {
            super(fury, cls);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            return new CollectionContainer(numElements);
        }

        @Override
        public T onCollectionRead(Collection collection) {
            Object[] elements = ((CollectionContainer)collection).elements;
            ImmutableList list = ImmutableList.copyOf((Object[])elements);
            return (T)list;
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        public T xnewInstance(Collection collection) {
            return (T)ImmutableList.copyOf((Collection)collection);
        }

        @Override
        public T copy(T originCollection) {
            Object[] elements = new Object[originCollection.size()];
            this.copyElements((Collection)originCollection, elements);
            return (T)ImmutableList.copyOf((Object[])elements);
        }
    }

    static abstract class GuavaCollectionSerializer<T extends Collection>
    extends CollectionSerializer<T> {
        public GuavaCollectionSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, true);
            fury.getClassResolver().setSerializer(cls, this);
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            int size = buffer.readVarUint32Small7();
            ArrayList list = new ArrayList();
            this.xreadElements(this.fury, buffer, list, size);
            return this.xnewInstance(list);
        }

        protected abstract T xnewInstance(Collection var1);
    }
}

