/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.resolver;

import org.apache.fury.collection.LongMap;
import org.apache.fury.collection.ObjectMap;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.meta.Encoders;
import org.apache.fury.meta.MetaString;
import org.apache.fury.resolver.MetaStringBytes;

public final class MetaStringResolver {
    private static final int initialCapacity = 8;
    private static final float furyMapLoadFactor = 0.25f;
    private final ObjectMap<MetaStringBytes, String> metaStringBytes2StringMap = new ObjectMap(8, 0.25f);
    private final LongMap<MetaStringBytes> hash2MetaStringBytesMap = new LongMap(8, 0.25f);
    private final ObjectMap<MetaString, MetaStringBytes> metaString2BytesMap = new ObjectMap(8, 0.25f);
    private MetaStringBytes[] dynamicWrittenString = new MetaStringBytes[32];
    private MetaStringBytes[] dynamicReadStringIds = new MetaStringBytes[32];
    private short dynamicWriteStringId = 0;
    private short dynamicReadStringId = 0;

    MetaStringBytes getOrCreateMetaStringBytes(MetaString str) {
        MetaStringBytes metaStringBytes = (MetaStringBytes)this.metaString2BytesMap.get(str);
        if (metaStringBytes == null) {
            metaStringBytes = new MetaStringBytes(str);
            this.metaString2BytesMap.put(str, metaStringBytes);
        }
        return metaStringBytes;
    }

    public void writeMetaStringBytesWithFlag(MemoryBuffer buffer, MetaStringBytes byteString) {
        short id = byteString.dynamicWriteStringId;
        if (id == -1) {
            short s = this.dynamicWriteStringId;
            this.dynamicWriteStringId = (short)(s + 1);
            byteString.dynamicWriteStringId = id = s;
            MetaStringBytes[] dynamicWrittenMetaString = this.dynamicWrittenString;
            if (dynamicWrittenMetaString.length <= id) {
                dynamicWrittenMetaString = this.growWrite(id);
            }
            dynamicWrittenMetaString[id] = byteString;
            buffer.writeVarUint32Small7(byteString.bytes.length << 2 | 1);
            buffer.writeInt64(byteString.hashCode);
            buffer.writeBytes(byteString.bytes);
        } else {
            buffer.writeVarUint32Small7(id + 1 << 2 | 3);
        }
    }

    public void writeMetaStringBytes(MemoryBuffer buffer, MetaStringBytes byteString) {
        short id = byteString.dynamicWriteStringId;
        if (id == -1) {
            short s = this.dynamicWriteStringId;
            this.dynamicWriteStringId = (short)(s + 1);
            byteString.dynamicWriteStringId = id = s;
            MetaStringBytes[] dynamicWrittenMetaString = this.dynamicWrittenString;
            if (dynamicWrittenMetaString.length <= id) {
                dynamicWrittenMetaString = this.growWrite(id);
            }
            dynamicWrittenMetaString[id] = byteString;
            buffer.writeVarUint32Small7(byteString.bytes.length << 1);
            buffer.writeInt64(byteString.hashCode);
            buffer.writeBytes(byteString.bytes);
        } else {
            buffer.writeVarUint32Small7(id + 1 << 1 | 1);
        }
    }

    private MetaStringBytes[] growWrite(int id) {
        MetaStringBytes[] tmp = new MetaStringBytes[id * 2];
        System.arraycopy(this.dynamicWrittenString, 0, tmp, 0, this.dynamicWrittenString.length);
        this.dynamicWrittenString = tmp;
        return tmp;
    }

    public String readMetaString(MemoryBuffer buffer) {
        MetaStringBytes byteString = this.readMetaStringBytes(buffer);
        String str = (String)this.metaStringBytes2StringMap.get(byteString);
        if (str == null) {
            str = byteString.decode(Encoders.GENERIC_DECODER);
            this.metaStringBytes2StringMap.put(byteString, str);
        }
        return str;
    }

    public MetaStringBytes readMetaStringBytesWithFlag(MemoryBuffer buffer, int header) {
        int len = header >>> 2;
        if ((header & 2) == 0) {
            long hashCode = buffer.readInt64();
            MetaStringBytes byteString = this.trySkipMetaStringBytes(buffer, len, hashCode);
            this.updateDynamicString(byteString);
            return byteString;
        }
        return this.dynamicReadStringIds[len - 1];
    }

    public MetaStringBytes readMetaStringBytesWithFlag(MemoryBuffer buffer, MetaStringBytes cache, int header) {
        int len = header >>> 2;
        if ((header & 2) == 0) {
            long hashCode = buffer.readInt64();
            if (cache.hashCode == hashCode) {
                buffer.increaseReaderIndex(len);
                this.updateDynamicString(cache);
                return cache;
            }
            MetaStringBytes byteString = this.trySkipMetaStringBytes(buffer, len, hashCode);
            this.updateDynamicString(byteString);
            return byteString;
        }
        return this.dynamicReadStringIds[len - 1];
    }

    MetaStringBytes readMetaStringBytes(MemoryBuffer buffer) {
        int header = buffer.readVarUint32Small7();
        int len = header >>> 1;
        if ((header & 1) == 0) {
            long hashCode = buffer.readInt64();
            MetaStringBytes byteString = this.trySkipMetaStringBytes(buffer, len, hashCode);
            this.updateDynamicString(byteString);
            return byteString;
        }
        return this.dynamicReadStringIds[len - 1];
    }

    MetaStringBytes readMetaStringBytes(MemoryBuffer buffer, MetaStringBytes cache) {
        int header = buffer.readVarUint32Small7();
        int len = header >>> 1;
        if ((header & 1) == 0) {
            long hashCode = buffer.readInt64();
            if (cache.hashCode == hashCode) {
                buffer.increaseReaderIndex(len);
                this.updateDynamicString(cache);
                return cache;
            }
            MetaStringBytes byteString = this.trySkipMetaStringBytes(buffer, len, hashCode);
            this.updateDynamicString(byteString);
            return byteString;
        }
        return this.dynamicReadStringIds[len - 1];
    }

    private MetaStringBytes trySkipMetaStringBytes(MemoryBuffer buffer, int len, long hashCode) {
        MetaStringBytes byteString = this.hash2MetaStringBytesMap.get(hashCode);
        if (byteString == null) {
            byteString = new MetaStringBytes(buffer.readBytes(len), hashCode);
            this.hash2MetaStringBytesMap.put(hashCode, byteString);
        } else {
            buffer.increaseReaderIndex(len);
        }
        return byteString;
    }

    private void updateDynamicString(MetaStringBytes byteString) {
        short s = this.dynamicReadStringId;
        this.dynamicReadStringId = (short)(s + 1);
        MetaStringBytes[] dynamicReadStringIds = this.dynamicReadStringIds;
        short currentDynamicReadId = s;
        if (dynamicReadStringIds.length <= currentDynamicReadId) {
            dynamicReadStringIds = this.growRead(currentDynamicReadId);
        }
        dynamicReadStringIds[currentDynamicReadId] = byteString;
    }

    private MetaStringBytes[] growRead(int id) {
        MetaStringBytes[] tmp = new MetaStringBytes[id * 2];
        System.arraycopy(this.dynamicReadStringIds, 0, tmp, 0, this.dynamicReadStringIds.length);
        this.dynamicReadStringIds = tmp;
        return tmp;
    }

    public void reset() {
        this.resetRead();
        this.resetWrite();
    }

    public void resetRead() {
        int dynamicReadId = this.dynamicReadStringId;
        if (dynamicReadId != 0) {
            for (int i = 0; i < dynamicReadId; ++i) {
                this.dynamicReadStringIds[i] = null;
            }
            this.dynamicReadStringId = 0;
        }
    }

    public void resetWrite() {
        int dynamicWriteStringId = this.dynamicWriteStringId;
        if (dynamicWriteStringId != 0) {
            for (int i = 0; i < dynamicWriteStringId; ++i) {
                this.dynamicWrittenString[i].dynamicWriteStringId = (short)-1;
                this.dynamicWrittenString[i] = null;
            }
            this.dynamicWriteStringId = 0;
        }
    }
}

