/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.resolver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.fury.exception.InsecureException;

class DisallowedList {
    private static final String DISALLOWED_LIST_TXT_PATH = "fury/disallowed.txt";
    private static final Set<String> DEFAULT_DISALLOWED_LIST_SET;

    DisallowedList() {
    }

    static void checkNotInDisallowedList(String clsName) {
        if (DEFAULT_DISALLOWED_LIST_SET.contains(clsName)) {
            throw new InsecureException(String.format("%s hit disallowed list", clsName));
        }
    }

    static {
        block15: {
            try (InputStream is = DisallowedList.class.getClassLoader().getResourceAsStream(DISALLOWED_LIST_TXT_PATH);){
                if (is != null) {
                    DEFAULT_DISALLOWED_LIST_SET = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().filter(line -> !line.isEmpty() && !line.startsWith("#")).collect(Collectors.toSet());
                    break block15;
                }
                throw new IllegalStateException(String.format("Read disallowed list %s failed", DISALLOWED_LIST_TXT_PATH));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Read disallowed list %s failed", DISALLOWED_LIST_TXT_PATH), e);
            }
        }
    }
}

