/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.reflect;

import java.lang.reflect.Field;
import org.apache.fury.memory.Platform;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.util.Preconditions;

public class UnsafeFieldAccessor {
    private final Field field;
    private final long fieldOffset;

    public UnsafeFieldAccessor(Class<?> cls, String fieldName) {
        this(ReflectionUtils.getField(cls, fieldName));
    }

    public UnsafeFieldAccessor(Field field) {
        Preconditions.checkNotNull(field);
        this.field = field;
        this.fieldOffset = ReflectionUtils.getFieldOffset(field);
        Preconditions.checkArgument(this.fieldOffset != -1L);
    }

    public Field getField() {
        return this.field;
    }

    public boolean getBoolean(Object obj) {
        return Platform.UNSAFE.getBoolean(obj, this.fieldOffset);
    }

    public void putBoolean(Object obj, boolean value) {
        Platform.UNSAFE.putBoolean(obj, this.fieldOffset, value);
    }

    public byte getByte(Object obj) {
        return Platform.UNSAFE.getByte(obj, this.fieldOffset);
    }

    public void putByte(Object obj, byte value) {
        Platform.UNSAFE.putByte(obj, this.fieldOffset, value);
    }

    public char getChar(Object obj) {
        return Platform.UNSAFE.getChar(obj, this.fieldOffset);
    }

    public void putChar(Object obj, char value) {
        Platform.UNSAFE.putChar(obj, this.fieldOffset, value);
    }

    public short getShort(Object obj) {
        return Platform.UNSAFE.getShort(obj, this.fieldOffset);
    }

    public void putShort(Object obj, short value) {
        Platform.UNSAFE.putShort(obj, this.fieldOffset, value);
    }

    public int getInt(Object obj) {
        return Platform.UNSAFE.getInt(obj, this.fieldOffset);
    }

    public void putInt(Object obj, int value) {
        Platform.UNSAFE.putInt(obj, this.fieldOffset, value);
    }

    public long getLong(Object obj) {
        return Platform.UNSAFE.getLong(obj, this.fieldOffset);
    }

    public void putLong(Object obj, long value) {
        Platform.UNSAFE.putLong(obj, this.fieldOffset, value);
    }

    public float getFloat(Object obj) {
        return Platform.UNSAFE.getFloat(obj, this.fieldOffset);
    }

    public void putFloat(Object obj, float value) {
        Platform.UNSAFE.putFloat(obj, this.fieldOffset, value);
    }

    public double getDouble(Object obj) {
        return Platform.UNSAFE.getDouble(obj, this.fieldOffset);
    }

    public void putDouble(Object obj, double value) {
        Platform.UNSAFE.putDouble(obj, this.fieldOffset, value);
    }

    public Object getObject(Object obj) {
        return Platform.UNSAFE.getObject(obj, this.fieldOffset);
    }

    public void putObject(Object obj, Object value) {
        Platform.UNSAFE.putObject(obj, this.fieldOffset, value);
    }
}

