/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.logging;

import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogger
implements Logger {
    private static final String FQCN = Slf4jLogger.class.getName();
    private final boolean isLocationAwareLogger;
    private final org.slf4j.Logger logger;

    public Slf4jLogger(Class<?> cls) {
        this.logger = org.slf4j.LoggerFactory.getLogger(cls);
        this.isLocationAwareLogger = this.logger instanceof LocationAwareLogger;
    }

    @Override
    public void info(String msg) {
        this.info(msg, (Object[])null);
    }

    @Override
    public void info(String msg, Object arg) {
        this.info(msg, new Object[]{arg});
    }

    @Override
    public void info(String msg, Object arg1, Object arg2) {
        this.info(msg, new Object[]{arg1, arg2});
    }

    @Override
    public void info(String msg, Object ... args) {
        if (LoggerFactory.getLogLevel() < 2) {
            return;
        }
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 20, msg, args, null);
        } else {
            this.logger.info(msg, args);
        }
    }

    @Override
    public void warn(String msg) {
        this.warn(msg, (Object[])null);
    }

    @Override
    public void warn(String msg, Object arg) {
        this.warn(msg, new Object[]{arg});
    }

    @Override
    public void warn(String msg, Object arg1, Object arg2) {
        this.warn(msg, new Object[]{arg1, arg2});
    }

    @Override
    public void warn(String msg, Object ... args) {
        if (LoggerFactory.getLogLevel() < 1) {
            return;
        }
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 30, msg, args, null);
        } else {
            this.logger.warn(msg, args);
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (LoggerFactory.getLogLevel() < 1) {
            return;
        }
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 30, msg, null, t);
        } else {
            this.logger.warn(msg, t);
        }
    }

    @Override
    public void error(String msg) {
        this.error(msg, (Object[])null);
    }

    @Override
    public void error(String msg, Object arg) {
        this.error(msg, new Object[]{arg});
    }

    @Override
    public void error(String msg, Object arg1, Object arg2) {
        this.error(msg, new Object[]{arg1, arg2});
    }

    @Override
    public void error(String msg, Object ... args) {
        if (LoggerFactory.getLogLevel() < 0) {
            return;
        }
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 40, msg, args, null);
        } else {
            this.logger.error(msg, args);
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        if (LoggerFactory.getLogLevel() < 0) {
            return;
        }
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, 40, msg, null, t);
        } else {
            this.logger.error(msg, t);
        }
    }
}

