/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.ReferenceKey;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

class ObjectReaderImplMapTyped
implements ObjectReader {
    final Class mapType;
    final Class instanceType;
    final Type keyType;
    final Type valueType;
    final Class valueClass;
    final long features;
    final Function builder;
    final boolean multiValue;
    final Constructor defaultConstructor;
    ObjectReader valueObjectReader;
    ObjectReader keyObjectReader;

    public ObjectReaderImplMapTyped(Class mapType, Class instanceType, Type keyType, Type valueType, long features, Function builder) {
        Constructor<?>[] constructors;
        if (keyType == Object.class) {
            keyType = null;
        }
        this.mapType = mapType;
        this.instanceType = instanceType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.valueClass = TypeUtils.getClass(valueType);
        this.features = features;
        this.builder = builder;
        this.multiValue = instanceType != null && "org.springframework.util.LinkedMultiValueMap".equals(instanceType.getName());
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : constructors = this.instanceType.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 0 || Modifier.isPublic(constructor.getModifiers())) continue;
            constructor.setAccessible(true);
            defaultConstructor = constructor;
            break;
        }
        this.defaultConstructor = defaultConstructor;
    }

    public Class getObjectClass() {
        return this.mapType;
    }

    public Object createInstance(Map input, long features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Map object = this.instanceType == Map.class || this.instanceType == HashMap.class ? new HashMap() : (Map)this.createInstance(features);
        for (Map.Entry entry : input.entrySet()) {
            Object key = entry.getKey();
            Object fieldValue = entry.getValue();
            String fieldName = this.keyType == null || this.keyType == String.class ? key.toString() : TypeUtils.cast(key, this.keyType);
            Object value = fieldValue;
            if (value != null) {
                Class<?> valueClass = value.getClass();
                if (this.valueType != Object.class) {
                    if (valueClass == JSONObject.class || valueClass == TypeUtils.CLASS_JSON_OBJECT_1x) {
                        if (this.valueObjectReader == null) {
                            this.valueObjectReader = provider.getObjectReader(this.valueType);
                        }
                        value = this.valueObjectReader.createInstance((Map)value, features);
                    } else if ((valueClass == JSONArray.class || valueClass == TypeUtils.CLASS_JSON_ARRAY_1x) && this.valueClass == List.class) {
                        if (this.valueObjectReader == null) {
                            this.valueObjectReader = provider.getObjectReader(this.valueType);
                        }
                        value = this.valueObjectReader.createInstance((Collection)((List)value), features);
                    } else {
                        Function typeConvert = provider.getTypeConvert(valueClass, this.valueType);
                        if (typeConvert != null) {
                            value = typeConvert.apply(value);
                        } else if (value instanceof Map) {
                            if (this.valueObjectReader == null) {
                                this.valueObjectReader = provider.getObjectReader(this.valueType);
                            }
                            value = this.valueObjectReader.createInstance((Map)value, features);
                        } else if (value instanceof Collection && !this.multiValue) {
                            if (this.valueObjectReader == null) {
                                this.valueObjectReader = provider.getObjectReader(this.valueType);
                            }
                            value = this.valueObjectReader.createInstance((Collection)value, features);
                        } else if (!valueClass.isInstance(value)) {
                            throw new JSONException("can not convert from " + valueClass + " to " + this.valueType);
                        }
                    }
                }
            }
            object.put(fieldName, value);
        }
        if (this.builder != null) {
            return this.builder.apply(object);
        }
        return object;
    }

    public Object createInstance(long features) {
        if (this.instanceType != null && !this.instanceType.isInterface()) {
            try {
                if (this.defaultConstructor != null) {
                    return this.defaultConstructor.newInstance(new Object[0]);
                }
                return this.instanceType.newInstance();
            }
            catch (Exception e) {
                throw new JSONException("create map error", e);
            }
        }
        return new HashMap();
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        byte firstType;
        ObjectReader objectReader = null;
        Function builder = this.builder;
        if (jsonReader.getType() == -110 && (objectReader = jsonReader.checkAutoType(this.mapType, 0L, this.features | features)) != null && objectReader != this) {
            builder = objectReader.getBuildFunction();
            if (!(objectReader instanceof ObjectReaderImplMap) && !(objectReader instanceof ObjectReaderImplMapTyped)) {
                return objectReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
            }
        }
        if ((firstType = jsonReader.getType()) == -81) {
            jsonReader.next();
            return null;
        }
        if (firstType == -90) {
            jsonReader.next();
        }
        JSONReader.Context context = jsonReader.getContext();
        long contextFeatures = features | context.getFeatures();
        Map<Object, Map<Object, Object>> object = objectReader != null ? (Map<Object, Map<Object, Object>>)objectReader.createInstance(contextFeatures) : (this.instanceType == HashMap.class ? new HashMap() : (Map)this.createInstance(features));
        int i = 0;
        while (true) {
            String reference;
            Object name;
            byte type;
            if ((type = jsonReader.getType()) == -91) break;
            if (this.keyType == String.class || jsonReader.isString()) {
                name = jsonReader.readFieldName();
            } else if (jsonReader.isReference()) {
                reference = jsonReader.readReference();
                name = new ReferenceKey(i);
                jsonReader.addResolveTask(object, name, JSONPath.of(reference));
            } else {
                if (this.keyObjectReader == null && this.keyType != null) {
                    this.keyObjectReader = jsonReader.getObjectReader(this.keyType);
                }
                name = this.keyObjectReader == null ? jsonReader.readAny() : this.keyObjectReader.readJSONBObject(jsonReader, null, null, features);
            }
            if (jsonReader.isReference()) {
                reference = jsonReader.readReference();
                if ("..".equals(reference)) {
                    object.put(name, object);
                } else {
                    jsonReader.addResolveTask(object, name, JSONPath.of(reference));
                    if (!(object instanceof ConcurrentMap)) {
                        object.put(name, null);
                    }
                }
            } else if (jsonReader.nextIfNull()) {
                object.put(name, null);
            } else {
                Object value;
                if (this.valueType == Object.class) {
                    value = jsonReader.readAny();
                } else {
                    ObjectReader autoTypeValueReader = jsonReader.checkAutoType(this.valueClass, 0L, features);
                    if (autoTypeValueReader != null && autoTypeValueReader != this) {
                        value = autoTypeValueReader.readJSONBObject(jsonReader, this.valueType, name, features);
                    } else {
                        if (this.valueObjectReader == null) {
                            this.valueObjectReader = jsonReader.getObjectReader(this.valueType);
                        }
                        value = this.valueObjectReader.readJSONBObject(jsonReader, this.valueType, name, features);
                    }
                }
                if (value != null || (contextFeatures & JSONReader.Feature.IgnoreNullPropertyValue.mask) == 0L) {
                    object.put(name, (Map<Object, Object>)value);
                }
            }
            ++i;
        }
        jsonReader.next();
        if (builder != null) {
            if (builder == ObjectReaderImplMap.ENUM_MAP_BUILDER && object.isEmpty()) {
                return new EnumMap((Class)this.keyType);
            }
            return builder.apply(object);
        }
        return object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        index = 0;
        if (!jsonReader.nextIfObjectStart()) {
            if (jsonReader.isTypeRedirect()) {
                index = 1;
                jsonReader.setTypeRedirect(false);
            } else {
                if (jsonReader.nextIfNullOrEmptyString()) {
                    return null;
                }
                throw new JSONException(jsonReader.info("expect '{', but '" + jsonReader.current() + "'"));
            }
        }
        context = jsonReader.getContext();
        contextFeatures = context.getFeatures() | features;
        if (this.instanceType == HashMap.class) {
            objectSupplier = context.getObjectSupplier();
            if (this.mapType == Map.class && objectSupplier != null) {
                if (this.keyType != String.class && objectSupplier.getClass().getName().equals("com.alibaba.fastjson.JSONObject$Creator")) {
                    object = new HashMap<K, V>();
                } else {
                    object = objectSupplier.get();
                    object = TypeUtils.getInnerMap(object);
                }
            } else {
                object = new HashMap<K, V>();
            }
        } else {
            object = this.instanceType == EnumMap.class && this.keyType instanceof Class != false ? new EnumMap<K, V>((Class)this.keyType) : (HashMap<K, V>)this.createInstance(contextFeatures);
        }
        while (!jsonReader.nextIfObjectEnd() && !jsonReader.isEnd()) {
            block30: {
                block34: {
                    block35: {
                        block27: {
                            block33: {
                                block31: {
                                    block32: {
                                        block28: {
                                            block29: {
                                                block26: {
                                                    if (!jsonReader.nextIfNull()) break block26;
                                                    if (!jsonReader.nextIfMatch(':')) {
                                                        throw new JSONException(jsonReader.info("illegal json"));
                                                    }
                                                    name /* !! */  = null;
                                                    break block27;
                                                }
                                                if (this.keyType != String.class) break block28;
                                                name /* !! */  = jsonReader.readFieldName();
                                                if (index != 0 || (contextFeatures & JSONReader.Feature.SupportAutoType.mask) == 0L || !name /* !! */ .equals(this.getTypeKey())) break block29;
                                                typeHashCode = jsonReader.readTypeHashCode();
                                                objectReaderAutoType = jsonReader.getObjectReaderAutoType(typeHashCode, this.mapType, features);
                                                if (objectReaderAutoType != null && objectReaderAutoType instanceof ObjectReaderImplMap && !object.getClass().equals(((ObjectReaderImplMap)objectReaderAutoType).instanceType)) {
                                                    object = (Map)objectReaderAutoType.createInstance(features);
                                                }
                                                break block30;
                                            }
                                            if (name /* !! */  == null) {
                                                name /* !! */  = jsonReader.readString();
                                                if (!jsonReader.nextIfMatch(':')) {
                                                    throw new JSONException(jsonReader.info("illegal json"));
                                                }
                                            }
                                            break block27;
                                        }
                                        if (index != 0 || !jsonReader.isEnabled(JSONReader.Feature.SupportAutoType) && jsonReader.getContext().getContextAutoTypeBeforeHandler() == null || jsonReader.current() != '\"' || this.keyType instanceof Class && Enum.class.isAssignableFrom((Class)this.keyType)) break block31;
                                        name /* !! */  = jsonReader.readFieldName();
                                        if (!name /* !! */ .equals(this.getTypeKey())) break block32;
                                        typeHashCode = jsonReader.readTypeHashCode();
                                        objectReaderAutoType = jsonReader.getObjectReaderAutoType(typeHashCode, this.mapType, features);
                                        if (objectReaderAutoType != null && objectReaderAutoType instanceof ObjectReaderImplMap && !object.getClass().equals(((ObjectReaderImplMap)objectReaderAutoType).instanceType)) {
                                            object = (Map)objectReaderAutoType.createInstance(features);
                                        }
                                        break block30;
                                    }
                                    name /* !! */  = TypeUtils.cast((Object)name /* !! */ , this.keyType);
                                    break block27;
                                }
                                name /* !! */  = this.keyObjectReader != null ? this.keyObjectReader.readObject(jsonReader, null, null, 0L) : jsonReader.read(this.keyType);
                                if (name /* !! */  == null && Enum.class.isAssignableFrom((Class)this.keyType)) {
                                    name /* !! */  = jsonReader.getString();
                                    jsonReader.nextIfMatch(':');
                                }
                                if (index != 0 || (contextFeatures & JSONReader.Feature.SupportAutoType.mask) == 0L || !name /* !! */ .equals(this.getTypeKey())) break block33;
                                typeHashCode = jsonReader.readTypeHashCode();
                                objectReaderAutoType = jsonReader.getObjectReaderAutoType(typeHashCode, this.mapType, features);
                                if (objectReaderAutoType != null && objectReaderAutoType instanceof ObjectReaderImplMap && !object.getClass().equals(((ObjectReaderImplMap)objectReaderAutoType).instanceType)) {
                                    object = (Map)objectReaderAutoType.createInstance(features);
                                }
                                break block30;
                            }
                            jsonReader.nextIfMatch(':');
                        }
                        if (this.valueObjectReader == null) {
                            this.valueObjectReader = jsonReader.getObjectReader(this.valueType);
                        }
                        if (!jsonReader.isReference()) break block34;
                        reference = jsonReader.readReference();
                        if (!"..".equals(reference)) break block35;
                        value /* !! */  = object;
                        ** GOTO lbl95
                    }
                    jsonReader.addResolveTask(object, (Object)name /* !! */ , JSONPath.of(reference));
                    break block30;
                }
                if (this.multiValue && jsonReader.nextIfArrayStart()) {
                    list = new JSONArray();
                    while (!jsonReader.nextIfArrayEnd()) {
                        value = this.valueObjectReader.readObject(jsonReader, this.valueType, fieldName, 0L);
                        list.add(value);
                    }
                    object.put(name /* !! */ , (HashMap<String, JSONArray>)list);
                } else {
                    value /* !! */  = this.valueObjectReader.readObject(jsonReader, this.valueType, fieldName, 0L);
lbl95:
                    // 2 sources

                    if ((value /* !! */  != null || (contextFeatures & JSONReader.Feature.IgnoreNullPropertyValue.mask) == 0L) && (origin = object.put(name /* !! */ , value /* !! */ )) != null && (contextFeatures & JSONReader.Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                        if (origin instanceof Collection) {
                            ((Collection)origin).add(value /* !! */ );
                            object.put(name /* !! */ , origin);
                        } else {
                            array = JSONArray.of(origin, value /* !! */ );
                            object.put(name /* !! */ , (HashMap<String, JSONArray>)array);
                        }
                    }
                }
            }
            ++index;
        }
        jsonReader.nextIfComma();
        if (this.builder != null) {
            return this.builder.apply(object);
        }
        return object;
    }
}

