/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.namingserver.config;

import javax.servlet.Filter;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.seata.namingserver.filter.ConsoleRemotingFilter;
import org.apache.seata.namingserver.manager.NamingManager;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsAsyncClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.RestTemplate;

@Configuration
public class WebConfig {
    @Bean
    public RestTemplate restTemplate() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(20);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        requestFactory.setConnectTimeout(5000);
        requestFactory.setReadTimeout(5000);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    @Bean
    public AsyncRestTemplate asyncRestTemplate(RestTemplate restTemplate) {
        HttpComponentsAsyncClientHttpRequestFactory asyncClientHttpRequestFactory = new HttpComponentsAsyncClientHttpRequestFactory();
        asyncClientHttpRequestFactory.setConnectionRequestTimeout(5000);
        asyncClientHttpRequestFactory.setConnectTimeout(5000);
        asyncClientHttpRequestFactory.setReadTimeout(5000);
        return new AsyncRestTemplate((AsyncClientHttpRequestFactory)asyncClientHttpRequestFactory, restTemplate);
    }

    @Bean
    public FilterRegistrationBean<Filter> consoleRemotingFilter(NamingManager namingManager, AsyncRestTemplate asyncRestTemplate) {
        ConsoleRemotingFilter consoleRemotingFilter = new ConsoleRemotingFilter(namingManager, asyncRestTemplate);
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)consoleRemotingFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }
}

