/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test.compatibility;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Timing2 {
    private final long value;
    private final TimeUnit unit;
    private final int waitingMultiple;
    private static final double TICK_TIME_MULTIPLE = 0.1;
    private static final int DEFAULT_SECONDS = 10;
    private static final int DEFAULT_WAITING_MULTIPLE = 5;
    private static final double SESSION_MULTIPLE = 1.5;
    private static final double SESSION_SLEEP_MULTIPLE = 2.625;

    public Timing2() {
        this((double)Integer.getInteger("timing-multiple", 1).intValue(), Timing2.getWaitingMultiple());
    }

    public Timing2(double multiple) {
        this((long)(10.0 * multiple), TimeUnit.SECONDS, Timing2.getWaitingMultiple());
    }

    public Timing2(double multiple, int waitingMultiple) {
        this((long)(10.0 * multiple), TimeUnit.SECONDS, waitingMultiple);
    }

    public Timing2(long value, TimeUnit unit) {
        this(value, unit, Timing2.getWaitingMultiple());
    }

    public Timing2(long value, TimeUnit unit, int waitingMultiple) {
        this.value = value;
        this.unit = unit;
        this.waitingMultiple = waitingMultiple;
    }

    public int milliseconds() {
        return (int)TimeUnit.MILLISECONDS.convert(this.value, this.unit);
    }

    public int seconds() {
        return (int)this.value;
    }

    public boolean awaitLatch(CountDownLatch latch) {
        Timing2 m = this.forWaiting();
        try {
            return latch.await(m.value, m.unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public <T> T takeFromQueue(BlockingQueue<T> queue) throws Exception {
        Timing2 m = this.forWaiting();
        try {
            T value = queue.poll(m.value, m.unit);
            if (value == null) {
                throw new TimeoutException("Timed out trying to take from queue");
            }
            return value;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    public boolean acquireSemaphore(Semaphore semaphore) {
        Timing2 m = this.forWaiting();
        try {
            return semaphore.tryAcquire(m.value, m.unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean acquireSemaphore(Semaphore semaphore, int n) {
        Timing2 m = this.forWaiting();
        try {
            return semaphore.tryAcquire(n, m.value, m.unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public Timing2 multiple(double n) {
        return new Timing2((int)((double)this.value * n), this.unit);
    }

    public Timing2 multiple(double n, int waitingMultiple) {
        return new Timing2((int)((double)this.value * n), this.unit, waitingMultiple);
    }

    public Timing2 forWaiting() {
        return this.multiple(this.waitingMultiple);
    }

    public Timing2 forSessionSleep() {
        return this.multiple(2.625, 1);
    }

    public Timing2 forSleepingABit() {
        return this.multiple(0.25);
    }

    public void sleepABit() throws InterruptedException {
        this.forSleepingABit().sleep();
    }

    public void sleep() throws InterruptedException {
        this.unit.sleep(this.value);
    }

    public int session() {
        return this.multiple(1.5).milliseconds();
    }

    public int connection() {
        return this.milliseconds();
    }

    public int tickTime() {
        return (int)Math.max(1.0, (double)this.milliseconds() * 0.1);
    }

    private static Integer getWaitingMultiple() {
        return Integer.getInteger("timing-waiting-multiple", 5);
    }
}

