/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.jvm.gc;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.apache.skywalking.apm.agent.core.jvm.gc.CMSGCModule;
import org.apache.skywalking.apm.agent.core.jvm.gc.G1GCModule;
import org.apache.skywalking.apm.agent.core.jvm.gc.GCMetricAccessor;
import org.apache.skywalking.apm.agent.core.jvm.gc.ParallelGCModule;
import org.apache.skywalking.apm.agent.core.jvm.gc.SerialGCModule;
import org.apache.skywalking.apm.agent.core.jvm.gc.UnknowGC;
import org.apache.skywalking.apm.network.language.agent.v3.GC;

public enum GCProvider {
    INSTANCE;

    private GCMetricAccessor metricAccessor;
    private List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();

    private GCProvider() {
        for (GarbageCollectorMXBean bean : this.beans) {
            String name = bean.getName();
            GCMetricAccessor accessor = this.findByBeanName(name);
            if (accessor == null) continue;
            this.metricAccessor = accessor;
            break;
        }
        if (this.metricAccessor == null) {
            this.metricAccessor = new UnknowGC();
        }
    }

    public List<GC> getGCList() {
        return this.metricAccessor.getGCList();
    }

    private GCMetricAccessor findByBeanName(String name) {
        if (name.indexOf("PS") > -1) {
            return new ParallelGCModule(this.beans);
        }
        if (name.indexOf("ConcurrentMarkSweep") > -1) {
            return new CMSGCModule(this.beans);
        }
        if (name.indexOf("G1") > -1) {
            return new G1GCModule(this.beans);
        }
        if (name.equals("MarkSweepCompact")) {
            return new SerialGCModule(this.beans);
        }
        return null;
    }
}

