/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.utils;

import com.alibaba.nacos.api.selector.ExpressionSelector;
import com.alibaba.nacos.api.selector.NoneSelector;
import com.alibaba.nacos.api.selector.SelectorType;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.alibaba.nacos.client.utils.ContextPathUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.client.utils.TenantUtil;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Properties;
import java.util.concurrent.Callable;

public class InitUtils {
    public static String initNamespaceForNaming(Properties properties) {
        String tmpNamespace = null;
        String isUseCloudNamespaceParsing = properties.getProperty("isUseCloudNamespaceParsing", System.getProperty("nacos.use.cloud.namespace.parsing", String.valueOf(true)));
        if (Boolean.parseBoolean(isUseCloudNamespaceParsing)) {
            tmpNamespace = TenantUtil.getUserTenantForAns();
            tmpNamespace = TemplateUtils.stringEmptyAndThenExecute(tmpNamespace, new Callable<String>(){

                @Override
                public String call() {
                    String namespace = System.getProperty("ans.namespace");
                    LogUtils.NAMING_LOGGER.info("initializer namespace from System Property :" + namespace);
                    return namespace;
                }
            });
            tmpNamespace = TemplateUtils.stringEmptyAndThenExecute(tmpNamespace, new Callable<String>(){

                @Override
                public String call() {
                    String namespace = System.getenv("ALIBABA_ALIWARE_NAMESPACE");
                    LogUtils.NAMING_LOGGER.info("initializer namespace from System Environment :" + namespace);
                    return namespace;
                }
            });
        }
        if (StringUtils.isEmpty((String)(tmpNamespace = TemplateUtils.stringEmptyAndThenExecute(tmpNamespace, new Callable<String>(){

            @Override
            public String call() {
                String namespace = System.getProperty("namespace");
                LogUtils.NAMING_LOGGER.info("initializer namespace from System Property :" + namespace);
                return namespace;
            }
        }))) && properties != null) {
            tmpNamespace = properties.getProperty("namespace");
        }
        tmpNamespace = TemplateUtils.stringEmptyAndThenExecute(tmpNamespace, new Callable<String>(){

            @Override
            public String call() {
                return "public";
            }
        });
        return tmpNamespace;
    }

    public static void initWebRootContext(Properties properties) {
        final String webContext = properties.getProperty("contextPath");
        TemplateUtils.stringNotEmptyAndThenExecute(webContext, new Runnable(){

            @Override
            public void run() {
                UtilAndComs.webContext = ContextPathUtil.normalizeContextPath(webContext);
                UtilAndComs.nacosUrlBase = UtilAndComs.webContext + "/v1/ns";
                UtilAndComs.nacosUrlInstance = UtilAndComs.nacosUrlBase + "/instance";
            }
        });
        InitUtils.initWebRootContext();
    }

    @Deprecated
    public static void initWebRootContext() {
        final String webContext = System.getProperty("nacos.naming.web.context");
        TemplateUtils.stringNotEmptyAndThenExecute(webContext, new Runnable(){

            @Override
            public void run() {
                UtilAndComs.webContext = ContextPathUtil.normalizeContextPath(webContext);
                UtilAndComs.nacosUrlBase = UtilAndComs.webContext + "/v1/ns";
                UtilAndComs.nacosUrlInstance = UtilAndComs.nacosUrlBase + "/instance";
            }
        });
    }

    public static String initEndpoint(final Properties properties) {
        String endpointUrl;
        if (properties == null) {
            return "";
        }
        String isUseEndpointRuleParsing = properties.getProperty("isUseEndpointParsingRule", System.getProperty("nacos.use.endpoint.parsing.rule", String.valueOf(true)));
        boolean isUseEndpointParsingRule = Boolean.parseBoolean(isUseEndpointRuleParsing);
        if (isUseEndpointParsingRule) {
            endpointUrl = ParamUtil.parsingEndpointRule(properties.getProperty("endpoint"));
            if (StringUtils.isBlank((String)endpointUrl)) {
                return "";
            }
        } else {
            endpointUrl = properties.getProperty("endpoint");
        }
        if (StringUtils.isBlank((String)endpointUrl)) {
            return "";
        }
        String endpointPort = TemplateUtils.stringEmptyAndThenExecute(System.getenv("ALIBABA_ALIWARE_ENDPOINT_PORT"), new Callable<String>(){

            @Override
            public String call() {
                return properties.getProperty("endpointPort");
            }
        });
        endpointPort = TemplateUtils.stringEmptyAndThenExecute(endpointPort, new Callable<String>(){

            @Override
            public String call() {
                return "8080";
            }
        });
        return endpointUrl + ":" + endpointPort;
    }

    public static void initSerialization() {
        JacksonUtils.registerSubtype(NoneSelector.class, (String)SelectorType.none.name());
        JacksonUtils.registerSubtype(ExpressionSelector.class, (String)SelectorType.label.name());
    }
}

