/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.driver;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.livy.rsc.RSCConf;
import org.apache.livy.rsc.driver.RSCDriver;
import org.apache.spark.SparkConf;

public final class RSCDriverBootstrapper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Properties props;
        switch (args.length) {
            case 0: {
                props = System.getProperties();
                break;
            }
            case 1: {
                props = new Properties();
                File propertyFile = new File(args[0]);
                String fileName = propertyFile.getName();
                if (!fileName.startsWith("livyConf") && fileName.endsWith("properties")) {
                    throw new IllegalArgumentException("File name " + fileName + "is not a legal file name.");
                }
                try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(propertyFile), StandardCharsets.UTF_8);){
                    props.load(r);
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Too many arguments.");
            }
        }
        SparkConf conf = new SparkConf(false);
        RSCConf livyConf = new RSCConf(null);
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            if (key.startsWith("spark.__livy__.")) {
                livyConf.set(key.substring("spark.__livy__.".length()), value);
                props.remove(key);
                continue;
            }
            if (!key.startsWith("spark.")) continue;
            conf.set(key, value);
        }
        String driverClass = livyConf.get(RSCConf.Entry.DRIVER_CLASS);
        if (driverClass == null) {
            driverClass = RSCDriver.class.getName();
        }
        RSCDriver driver = (RSCDriver)((Object)Thread.currentThread().getContextClassLoader().loadClass(driverClass).getConstructor(SparkConf.class, RSCConf.class).newInstance(conf, livyConf));
        driver.run();
    }
}

