/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.session;

import java.util.List;
import org.apache.livy.Job;
import org.apache.livy.JobContext;
import org.apache.livy.thriftserver.session.DataType;
import org.apache.livy.thriftserver.session.SparkUtils;
import org.apache.livy.thriftserver.session.ThriftSessionState;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;

public abstract class SparkCatalogJob
implements Job<Void> {
    protected static final String DEFAULT_HIVE_CATALOG = "";
    private final String sessionId;
    private final String jobId;
    private final DataType[] resultTypes;

    public SparkCatalogJob(String sessionId, String jobId, DataType[] resultTypes) {
        this.sessionId = sessionId;
        this.jobId = jobId;
        this.resultTypes = resultTypes;
    }

    protected abstract List<Row> fetchCatalogObjects(SessionCatalog var1);

    public Void call(JobContext jc) throws Exception {
        SessionCatalog catalog = ((SparkSession)jc.sparkSession()).sessionState().catalog();
        List<Row> objects = this.fetchCatalogObjects(catalog);
        ThriftSessionState session = ThriftSessionState.get(jc, this.sessionId);
        session.registerStatement(this.jobId, SparkUtils.dataTypesToSchema(this.resultTypes), objects.iterator());
        return null;
    }

    protected String convertIdentifierPattern(String pattern, boolean datanucleusFormat) {
        if (pattern == null) {
            return this.convertPattern("%", true);
        }
        return this.convertPattern(pattern, datanucleusFormat);
    }

    protected String convertSchemaPattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return this.convertPattern("%", true);
        }
        return this.convertPattern(pattern, true);
    }

    private String convertPattern(String pattern, boolean datanucleusFormat) {
        String wStr = datanucleusFormat ? "*" : ".*";
        return pattern.replaceAll("([^\\\\])%", "$1" + wStr).replaceAll("\\\\%", "%").replaceAll("^%", wStr).replaceAll("([^\\\\])_", "$1.").replaceAll("\\\\_", "_").replaceAll("^_", ".");
    }
}

