/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.serde;

import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hive.service.rpc.thrift.TBinaryColumn;
import org.apache.hive.service.rpc.thrift.TBoolColumn;
import org.apache.hive.service.rpc.thrift.TByteColumn;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TDoubleColumn;
import org.apache.hive.service.rpc.thrift.TI16Column;
import org.apache.hive.service.rpc.thrift.TI32Column;
import org.apache.hive.service.rpc.thrift.TI64Column;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TStringColumn;
import org.apache.livy.thriftserver.serde.ColumnOrientedResultSet;
import org.apache.livy.thriftserver.serde.ThriftResultSet;
import org.apache.livy.thriftserver.session.ColumnBuffer;
import org.apache.livy.thriftserver.session.DataType;
import org.apache.livy.thriftserver.session.ResultSet;
import org.apache.livy.thriftserver.types.Field;
import org.apache.livy.thriftserver.types.Schema;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ThriftResultSet$ {
    public static final ThriftResultSet$ MODULE$;

    static {
        new ThriftResultSet$();
    }

    public ThriftResultSet apply(DataType[] types, TProtocolVersion protocolVersion) {
        Predef$.MODULE$.assert(protocolVersion.getValue() >= TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6.getValue());
        return new ColumnOrientedResultSet((ColumnBuffer[])Predef$.MODULE$.refArrayOps((Object[])types).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnBuffer apply(DataType x$1) {
                return new ColumnBuffer(x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnBuffer.class))));
    }

    public ThriftResultSet apply(Schema schema, TProtocolVersion protocolVersion) {
        return this.apply((DataType[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(Field x$2) {
                return x$2.fieldType().dataType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))), protocolVersion);
    }

    public ThriftResultSet apply(ResultSet resultSet) {
        return new ColumnOrientedResultSet(resultSet.getColumns());
    }

    /*
     * WARNING - void declaration
     */
    public TColumn toTColumn(ColumnBuffer columnBuffer) {
        void var2_2;
        TColumn value = new TColumn();
        byte[] nullsArray = columnBuffer.getNulls().toByteArray();
        ByteBuffer nullMasks = ByteBuffer.wrap(nullsArray);
        DataType dataType = columnBuffer.getType();
        if (DataType.BOOLEAN.equals(dataType)) {
            boolean[] bools = (boolean[])columnBuffer.getValues();
            value.setBoolVal(new TBoolColumn(Booleans.asList((boolean[])bools), nullMasks));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.BYTE.equals(dataType)) {
            byte[] bytes = (byte[])columnBuffer.getValues();
            value.setByteVal(new TByteColumn(Bytes.asList((byte[])bytes), nullMasks));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.SHORT.equals(dataType)) {
            short[] shorts = (short[])columnBuffer.getValues();
            value.setI16Val(new TI16Column(Shorts.asList((short[])shorts), nullMasks));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.INTEGER.equals(dataType)) {
            int[] integers = (int[])columnBuffer.getValues();
            value.setI32Val(new TI32Column(Ints.asList((int[])integers), nullMasks));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.LONG.equals(dataType)) {
            long[] longs = (long[])columnBuffer.getValues();
            value.setI64Val(new TI64Column(Longs.asList((long[])longs), nullMasks));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.FLOAT.equals(dataType)) {
            float[] floats = (float[])columnBuffer.getValues();
            ArrayList<Double> doubles = new ArrayList<Double>(floats.length);
            for (int i = 0; i < floats.length; ++i) {
                doubles.add(Predef$.MODULE$.double2Double(new StringOps(Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToFloat((float)floats[i])).toString())).toDouble()));
            }
            value.setDoubleVal(new TDoubleColumn(doubles, nullMasks));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.DOUBLE.equals(dataType)) {
            double[] doubles = (double[])columnBuffer.getValues();
            value.setDoubleVal(new TDoubleColumn(Doubles.asList((double[])doubles), nullMasks));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DataType.BINARY.equals(dataType)) {
            List binaries = (List)columnBuffer.getValues();
            value.setBinaryVal(new TBinaryColumn(binaries, nullMasks));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            List strings = (List)columnBuffer.getValues();
            value.setStringVal(new TStringColumn(strings, nullMasks));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    private ThriftResultSet$() {
        MODULE$ = this;
    }
}

