/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.session;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.livy.thriftserver.session.DataType;
import org.apache.livy.thriftserver.session.ScalaIterator;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;

public class ColumnBuffer {
    static final int DEFAULT_SIZE = 100;
    static final String EMPTY_STRING = "";
    static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    private final DataType type;
    private byte[] nulls;
    private int currentSize;
    private boolean[] bools;
    private byte[] bytes;
    private short[] shorts;
    private int[] ints;
    private long[] longs;
    private float[] floats;
    private double[] doubles;
    private String[] strings;
    private byte[][] buffers;

    public ColumnBuffer() {
        this.type = null;
    }

    public ColumnBuffer(DataType type) {
        this.type = type;
        switch (type) {
            case BOOLEAN: {
                this.bools = new boolean[100];
                break;
            }
            case BYTE: {
                this.bytes = new byte[100];
                break;
            }
            case SHORT: {
                this.shorts = new short[100];
                break;
            }
            case INTEGER: {
                this.ints = new int[100];
                break;
            }
            case LONG: {
                this.longs = new long[100];
                break;
            }
            case FLOAT: {
                this.floats = new float[100];
                break;
            }
            case DOUBLE: {
                this.doubles = new double[100];
                break;
            }
            case BINARY: {
                this.buffers = new byte[100][];
                break;
            }
            case STRING: {
                this.strings = new String[100];
            }
        }
    }

    public DataType getType() {
        return this.type;
    }

    public Object get(int index) {
        if (index >= this.currentSize) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.isNull(index)) {
            return null;
        }
        switch (this.type) {
            case BOOLEAN: {
                return this.bools[index];
            }
            case BYTE: {
                return this.bytes[index];
            }
            case SHORT: {
                return this.shorts[index];
            }
            case INTEGER: {
                return this.ints[index];
            }
            case LONG: {
                return this.longs[index];
            }
            case FLOAT: {
                return Float.valueOf(this.floats[index]);
            }
            case DOUBLE: {
                return this.doubles[index];
            }
            case BINARY: {
                return ByteBuffer.wrap(this.buffers[index]);
            }
            case STRING: {
                return this.strings[index];
            }
        }
        throw new IllegalStateException("ShouldNotReachHere()");
    }

    public int size() {
        return this.currentSize;
    }

    public void add(Object value) {
        if (value == null) {
            this.setNull(this.currentSize);
            ++this.currentSize;
            return;
        }
        this.ensureCapacity();
        switch (this.type) {
            case BOOLEAN: {
                this.bools[this.currentSize] = (Boolean)value;
                break;
            }
            case BYTE: {
                this.bytes[this.currentSize] = (Byte)value;
                break;
            }
            case SHORT: {
                this.shorts[this.currentSize] = (Short)value;
                break;
            }
            case INTEGER: {
                this.ints[this.currentSize] = (Integer)value;
                break;
            }
            case LONG: {
                this.longs[this.currentSize] = (Long)value;
                break;
            }
            case FLOAT: {
                this.floats[this.currentSize] = ((Float)value).floatValue();
                break;
            }
            case DOUBLE: {
                this.doubles[this.currentSize] = (Double)value;
                break;
            }
            case BINARY: {
                this.buffers[this.currentSize] = (byte[])value;
                break;
            }
            case STRING: {
                this.strings[this.currentSize] = this.toHiveString(value, false);
            }
        }
        ++this.currentSize;
    }

    public Object getValues() {
        switch (this.type) {
            case BOOLEAN: {
                return this.bools.length != this.currentSize ? Arrays.copyOfRange(this.bools, 0, this.currentSize) : this.bools;
            }
            case BYTE: {
                return this.bytes.length != this.currentSize ? Arrays.copyOfRange(this.bytes, 0, this.currentSize) : this.bytes;
            }
            case SHORT: {
                return this.shorts.length != this.currentSize ? Arrays.copyOfRange(this.shorts, 0, this.currentSize) : this.shorts;
            }
            case INTEGER: {
                return this.ints.length != this.currentSize ? Arrays.copyOfRange(this.ints, 0, this.currentSize) : this.ints;
            }
            case LONG: {
                return this.longs.length != this.currentSize ? Arrays.copyOfRange(this.longs, 0, this.currentSize) : this.longs;
            }
            case FLOAT: {
                return this.floats.length != this.currentSize ? Arrays.copyOfRange(this.floats, 0, this.currentSize) : this.floats;
            }
            case DOUBLE: {
                return this.doubles.length != this.currentSize ? Arrays.copyOfRange(this.doubles, 0, this.currentSize) : this.doubles;
            }
            case BINARY: {
                return this.toList(Arrays.stream(this.buffers).map(b -> b != null ? ByteBuffer.wrap(b) : null), EMPTY_BUFFER);
            }
            case STRING: {
                return this.toList(Arrays.stream(this.strings), EMPTY_STRING);
            }
        }
        return null;
    }

    public BitSet getNulls() {
        return this.nulls != null ? BitSet.valueOf(this.nulls) : new BitSet();
    }

    private boolean isNull(int index) {
        if (this.nulls == null) {
            return false;
        }
        int byteIdx = index / 8;
        if (byteIdx >= this.nulls.length) {
            return false;
        }
        int bitIdx = index % 8;
        return (this.nulls[byteIdx] & 1 << bitIdx) != 0;
    }

    private <T> List<T> toList(Stream<T> data, T defaultValue) {
        ArrayList ret = new ArrayList(this.currentSize);
        data.limit(this.currentSize).forEach(e -> ret.add(e != null ? e : defaultValue));
        while (ret.size() < this.currentSize) {
            ret.add(defaultValue);
        }
        return ret;
    }

    private void setNull(int index) {
        int byteIdx = index / 8;
        if (this.nulls == null) {
            this.nulls = new byte[byteIdx + 1];
        } else if (byteIdx >= this.nulls.length) {
            this.nulls = Arrays.copyOf(this.nulls, byteIdx + 1);
        }
        int bitIdx = index % 8;
        this.nulls[byteIdx] = (byte)(this.nulls[byteIdx] | 1 << bitIdx);
    }

    private String toHiveString(Object value, boolean quoteStrings) {
        if (quoteStrings && value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).stripTrailingZeros().toString();
        }
        if (value instanceof Map) {
            return this.stream(new ScalaIterator(((Map)value).iterator())).map(o -> this.toHiveString(o, true)).sorted().collect(Collectors.joining(",", "{", "}"));
        }
        if (value instanceof Seq) {
            return this.stream(new ScalaIterator(((Seq)value).iterator())).map(o -> this.toHiveString(o, true)).collect(Collectors.joining(",", "[", "]"));
        }
        if (value instanceof Tuple2) {
            Tuple2 t = (Tuple2)value;
            return String.format("%s:%s", this.toHiveString(t._1(), true), this.toHiveString(t._2(), true));
        }
        if (value instanceof Row) {
            Row r = (Row)value;
            StructField[] fields = r.schema().fields();
            AtomicInteger idx = new AtomicInteger();
            return this.stream(new ScalaIterator(r.toSeq().iterator())).map(o -> {
                String fname = fields[idx.getAndIncrement()].name();
                String fval = this.toHiveString(o, true);
                return String.format("\"%s\":%s", fname, fval);
            }).collect(Collectors.joining(",", "{", "}"));
        }
        return value.toString();
    }

    private Stream<?> stream(Iterator<?> it) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    private void ensureCapacity() {
        int nextSize = this.currentSize + 100;
        nextSize -= nextSize % 100;
        switch (this.type) {
            case BOOLEAN: {
                if (this.bools.length > this.currentSize) break;
                this.bools = Arrays.copyOf(this.bools, nextSize);
                break;
            }
            case BYTE: {
                if (this.bytes.length > this.currentSize) break;
                this.bytes = Arrays.copyOf(this.bytes, nextSize);
                break;
            }
            case SHORT: {
                if (this.shorts.length > this.currentSize) break;
                this.shorts = Arrays.copyOf(this.shorts, nextSize);
                break;
            }
            case INTEGER: {
                if (this.ints.length > this.currentSize) break;
                this.ints = Arrays.copyOf(this.ints, nextSize);
                break;
            }
            case LONG: {
                if (this.longs.length > this.currentSize) break;
                this.longs = Arrays.copyOf(this.longs, nextSize);
                break;
            }
            case FLOAT: {
                if (this.floats.length > this.currentSize) break;
                this.floats = Arrays.copyOf(this.floats, nextSize);
                break;
            }
            case DOUBLE: {
                if (this.doubles.length > this.currentSize) break;
                this.doubles = Arrays.copyOf(this.doubles, nextSize);
                break;
            }
            case BINARY: {
                if (this.buffers.length > this.currentSize) break;
                this.buffers = (byte[][])Arrays.copyOf(this.buffers, nextSize);
                break;
            }
            case STRING: {
                if (this.strings.length > this.currentSize) break;
                this.strings = Arrays.copyOf(this.strings, nextSize);
            }
        }
    }
}

