/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.rpc;

import org.apache.hive.service.cli.SessionHandle;
import org.apache.livy.Job;
import org.apache.livy.JobHandle;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.rsc.RSCClient;
import org.apache.livy.server.interactive.InteractiveSession;
import org.apache.livy.thriftserver.session.CleanupStatementJob;
import org.apache.livy.thriftserver.session.FetchResultJob;
import org.apache.livy.thriftserver.session.FetchResultSchemaJob;
import org.apache.livy.thriftserver.session.RegisterSessionJob;
import org.apache.livy.thriftserver.session.ResultSet;
import org.apache.livy.thriftserver.session.SqlJob;
import org.apache.livy.thriftserver.session.UnregisterSessionJob;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\u0001\u0003\u00015\u0011\u0011B\u00159d\u00072LWM\u001c;\u000b\u0005\r!\u0011a\u0001:qG*\u0011QAB\u0001\ri\"\u0014\u0018N\u001a;tKJ4XM\u001d\u0006\u0003\u000f!\tA\u0001\\5ws*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\r%\u0011qC\u0002\u0002\b\u0019><w-\u001b8h\u0011!I\u0002A!A!\u0002\u0013Q\u0012a\u00037jmf\u001cVm]:j_:\u0004\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u0017%tG/\u001a:bGRLg/\u001a\u0006\u0003?\u0019\taa]3sm\u0016\u0014\u0018BA\u0011\u001d\u0005IIe\u000e^3sC\u000e$\u0018N^3TKN\u001c\u0018n\u001c8\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\t)s\u0005\u0005\u0002'\u00015\t!\u0001C\u0003\u001aE\u0001\u0007!\u0004C\u0004*\u0001\t\u0007I\u0011\u0002\u0016\u00023\u0011,g-Y;mi&s7M]3nK:$\u0018\r\\\"pY2,7\r^\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005Y\u0006twMC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#AB*ue&tw\r\u0003\u00045\u0001\u0001\u0006IaK\u0001\u001bI\u00164\u0017-\u001e7u\u0013:\u001c'/Z7f]R\fGnQ8mY\u0016\u001cG\u000f\t\u0005\bm\u0001\u0011\r\u0011\"\u00038\u0003%\u00118oY\"mS\u0016tG/F\u00019!\tID(D\u0001;\u0015\tYd!A\u0002sg\u000eL!!\u0010\u001e\u0003\u0013I\u001b6i\u00117jK:$\bBB \u0001A\u0003%\u0001(\u0001\u0006sg\u000e\u001cE.[3oi\u0002BQ!\u0011\u0001\u0005\u0002\t\u000bq![:WC2LG-F\u0001D!\tyA)\u0003\u0002F!\t9!i\\8mK\u0006t\u0007\"B$\u0001\t\u0013A\u0015!C:fgNLwN\\%e)\tIu\n\u0005\u0002K\u001b:\u0011qbS\u0005\u0003\u0019B\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001aO\u0015\ta\u0005\u0003C\u0003Q\r\u0002\u0007\u0011+A\u0007tKN\u001c\u0018n\u001c8IC:$G.\u001a\t\u0003%fk\u0011a\u0015\u0006\u0003)V\u000b1a\u00197j\u0015\t1v+A\u0004tKJ4\u0018nY3\u000b\u0005aC\u0011\u0001\u00025jm\u0016L!AW*\u0003\u001bM+7o]5p]\"\u000bg\u000e\u001a7f\u0011\u0015a\u0006\u0001\"\u0001^\u0003))\u00070Z2vi\u0016\u001c\u0016\u000f\u001c\u000b\u0005=6t\u0007\u000f\r\u0002`IB\u0019Q\u0003\u00192\n\u0005\u00054!!\u0003&pE\"\u000bg\u000e\u001a7f!\t\u0019G\r\u0004\u0001\u0005\u0013\u0015\\\u0016\u0011!A\u0001\u0006\u00031'aA0%cE\u0011qM\u001b\t\u0003\u001f!L!!\u001b\t\u0003\u000f9{G\u000f[5oOB\u0011qb[\u0005\u0003YB\u00111!\u00118z\u0011\u0015\u00016\f1\u0001R\u0011\u0015y7\f1\u0001J\u0003-\u0019H/\u0019;f[\u0016tG/\u00133\t\u000bE\\\u0006\u0019A%\u0002\u0013M$\u0018\r^3nK:$\b\u0006B.t\u0003\u000b\u00012a\u0004;w\u0013\t)\bC\u0001\u0004uQJ|wo\u001d\t\u0003o~t!\u0001_?\u000f\u0005edX\"\u0001>\u000b\u0005md\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\tq\b#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00111\u0001\u0002\n\u000bb\u001cW\r\u001d;j_:T!A \t2\ryI\u0015qAA\u0017c%\u0019\u0013\u0011BA\t\u0003G\t\u0019\"\u0006\u0003\u0002\f\u00055Q#A%\u0005\u000f\u0005=AB1\u0001\u0002\u001a\t\tA+\u0003\u0003\u0002\u0014\u0005U\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002\u0018A\ta\u0001\u001e5s_^\u001c\u0018cA4\u0002\u001cA!\u0011QDA\u0010\u001d\tyQ0\u0003\u0003\u0002\"\u0005\r!!\u0003+ie><\u0018M\u00197fc%\u0019\u0013QEA\u0014\u0003S\t9BD\u0002\u0010\u0003OI1!a\u0006\u0011c\u0015\u0011s\u0002EA\u0016\u0005\u0015\u00198-\u00197bc\t1c\u000fC\u0004\u00022\u0001!\t!a\r\u0002\u0017\u0019,Go\u00195SKN,H\u000e\u001e\u000b\t\u0003k\t\u0019%!\u0012\u0002HA!Q\u0003YA\u001c!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001f\t\u000591/Z:tS>t\u0017\u0002BA!\u0003w\u0011\u0011BU3tk2$8+\u001a;\t\rA\u000by\u00031\u0001R\u0011\u0019y\u0017q\u0006a\u0001\u0013\"A\u0011\u0011JA\u0018\u0001\u0004\tY%A\u0004nCb\u0014vn^:\u0011\u0007=\ti%C\u0002\u0002PA\u00111!\u00138uQ\u0015\tyc]A*c\u0019q\u0012*!\u0016\u0002\\EJ1%!\u0003\u0002\u0012\u0005]\u00131C\u0019\nG\u0005\u0015\u0012qEA-\u0003/\tTAI\b\u0011\u0003W\t$A\n<\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b\u0005\tb-\u001a;dQJ+7/\u001e7u'\u000eDW-\\1\u0015\r\u0005\r\u0014QMA4!\r)\u0002-\u0013\u0005\u0007!\u0006u\u0003\u0019A)\t\r=\fi\u00061\u0001JQ\u0015\tif]A6c\u0019q\u0012*!\u001c\u0002tEJ1%!\u0003\u0002\u0012\u0005=\u00141C\u0019\nG\u0005\u0015\u0012qEA9\u0003/\tTAI\b\u0011\u0003W\t$A\n<\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z\u0005\u00012\r\\3b]V\u00048\u000b^1uK6,g\u000e\u001e\u000b\t\u0003w\n))a\"\u0002\nB\"\u0011QPAA!\u0011)\u0002-a \u0011\u0007\r\f\t\tB\u0006\u0002\u0004\u0006U\u0014\u0011!A\u0001\u0006\u00031'aA0%e!1\u0001+!\u001eA\u0002ECaa\\A;\u0001\u0004I\u0005\"CAF\u0003k\u0002\n\u00111\u0001D\u0003%\u0019\u0017M\\2fY*{'\rK\u0003\u0002vM\fy)\r\u0004\u001f\u0013\u0006E\u0015qS\u0019\nG\u0005%\u0011\u0011CAJ\u0003'\t\u0014bIA\u0013\u0003O\t)*a\u00062\u000b\tz\u0001#a\u000b2\u0005\u00192\bbBAN\u0001\u0011\u0005\u0011QT\u0001\u0017Kb,7-\u001e;f%\u0016<\u0017n\u001d;feN+7o]5p]R!\u0011qTAUa\u0011\t\t+!*\u0011\tU\u0001\u00171\u0015\t\u0004G\u0006\u0015FaCAT\u00033\u000b\t\u0011!A\u0003\u0002\u0019\u00141a\u0018\u00134\u0011\u0019\u0001\u0016\u0011\u0014a\u0001#\"*\u0011\u0011T:\u0002.F2a$SAX\u0003k\u000b\u0014bIA\u0005\u0003#\t\t,a\u00052\u0013\r\n)#a\n\u00024\u0006]\u0011'\u0002\u0012\u0010!\u0005-\u0012G\u0001\u0014w\u0011\u001d\tI\f\u0001C\u0001\u0003w\u000b\u0001$\u001a=fGV$X-\u00168sK\u001eL7\u000f^3s'\u0016\u001c8/[8o)\u0011\ti,a21\t\u0005}\u00161\u0019\t\u0005+\u0001\f\t\rE\u0002d\u0003\u0007$1\"!2\u00028\u0006\u0005\t\u0011!B\u0001M\n\u0019q\f\n\u001b\t\rA\u000b9\f1\u0001RQ\u0015\t9l]Afc\u0019q\u0012*!4\u0002TFJ1%!\u0003\u0002\u0012\u0005=\u00171C\u0019\nG\u0005\u0015\u0012qEAi\u0003/\tTAI\b\u0011\u0003W\t$A\n<\t\u0013\u0005]\u0007!%A\u0005\u0002\u0005e\u0017AG2mK\u0006tW\u000f]*uCR,W.\u001a8uI\u0011,g-Y;mi\u0012\u001aTCAAnU\r\u0019\u0015Q\\\u0016\u0003\u0003?\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u001e\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002n\u0006\r(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class RpcClient
implements Logging {
    private final InteractiveSession livySession;
    private final String defaultIncrementalCollect;
    private final RSCClient rscClient;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        RpcClient rpcClient = this;
        synchronized (rpcClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    private String defaultIncrementalCollect() {
        return this.defaultIncrementalCollect;
    }

    private RSCClient rscClient() {
        return this.rscClient;
    }

    public boolean isValid() {
        return this.rscClient().isAlive();
    }

    private String sessionId(SessionHandle sessionHandle) {
        return sessionHandle.getSessionId().toString();
    }

    public JobHandle<?> executeSql(SessionHandle sessionHandle, String statementId, String statement) throws Exception {
        this.info((Function0<Object>)new Serializable(this, sessionHandle, statementId, statement){
            public static final long serialVersionUID = 0L;
            private final SessionHandle sessionHandle$1;
            private final String statementId$2;
            private final String statement$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RSC client is executing SQL query: ", ", statementId = ", ", session = "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.statement$1, this.statementId$2}))).append((Object)this.sessionHandle$1).toString();
            }
            {
                this.sessionHandle$1 = sessionHandle$1;
                this.statementId$2 = statementId$2;
                this.statement$1 = statement$1;
            }
        });
        Predef$.MODULE$.require(statementId != null, (Function0)new Serializable(this, statementId){
            public static final long serialVersionUID = 0L;
            private final String statementId$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid statementId specified. StatementId = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.statementId$2}));
            }
            {
                this.statementId$2 = statementId$2;
            }
        });
        Predef$.MODULE$.require(statement != null, (Function0)new Serializable(this, statement){
            public static final long serialVersionUID = 0L;
            private final String statement$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid statement specified. StatementId = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.statement$1}));
            }
            {
                this.statement$1 = statement$1;
            }
        });
        this.livySession.recordActivity();
        return this.rscClient().submit((Job)new SqlJob(this.sessionId(sessionHandle), statementId, statement, this.defaultIncrementalCollect(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LivyConf$.MODULE$.THRIFT_INCR_COLLECT_ENABLED()}))));
    }

    public JobHandle<ResultSet> fetchResult(SessionHandle sessionHandle, String statementId, int maxRows) throws Exception {
        this.info((Function0<Object>)new Serializable(this, statementId, maxRows){
            public static final long serialVersionUID = 0L;
            private final String statementId$1;
            private final int maxRows$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RSC client is fetching result for statementId ", " with ", " maxRows."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.statementId$1, BoxesRunTime.boxToInteger((int)this.maxRows$1)}));
            }
            {
                this.statementId$1 = statementId$1;
                this.maxRows$1 = maxRows$1;
            }
        });
        Predef$.MODULE$.require(statementId != null, (Function0)new Serializable(this, statementId){
            public static final long serialVersionUID = 0L;
            private final String statementId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid statementId specified. StatementId = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.statementId$1}));
            }
            {
                this.statementId$1 = statementId$1;
            }
        });
        this.livySession.recordActivity();
        return this.rscClient().submit((Job)new FetchResultJob(this.sessionId(sessionHandle), statementId, maxRows));
    }

    public JobHandle<String> fetchResultSchema(SessionHandle sessionHandle, String statementId) throws Exception {
        this.info((Function0<Object>)new Serializable(this, statementId){
            public static final long serialVersionUID = 0L;
            private final String statementId$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RSC client is fetching result schema for statementId = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.statementId$3}));
            }
            {
                this.statementId$3 = statementId$3;
            }
        });
        Predef$.MODULE$.require(statementId != null, (Function0)new Serializable(this, statementId){
            public static final long serialVersionUID = 0L;
            private final String statementId$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid statementId specified. statementId = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.statementId$3}));
            }
            {
                this.statementId$3 = statementId$3;
            }
        });
        this.livySession.recordActivity();
        return this.rscClient().submit((Job)new FetchResultSchemaJob(this.sessionId(sessionHandle), statementId));
    }

    public JobHandle<?> cleanupStatement(SessionHandle sessionHandle, String statementId, boolean cancelJob) throws Exception {
        this.info((Function0<Object>)new Serializable(this, statementId){
            public static final long serialVersionUID = 0L;
            private final String statementId$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaning up remote session for statementId = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.statementId$4}));
            }
            {
                this.statementId$4 = statementId$4;
            }
        });
        Predef$.MODULE$.require(statementId != null, (Function0)new Serializable(this, statementId){
            public static final long serialVersionUID = 0L;
            private final String statementId$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid statementId specified. statementId = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.statementId$4}));
            }
            {
                this.statementId$4 = statementId$4;
            }
        });
        this.livySession.recordActivity();
        return this.rscClient().submit((Job)new CleanupStatementJob(this.sessionId(sessionHandle), statementId));
    }

    public boolean cleanupStatement$default$3() {
        return false;
    }

    public JobHandle<?> executeRegisterSession(SessionHandle sessionHandle) throws Exception {
        this.info((Function0<Object>)new Serializable(this, sessionHandle){
            public static final long serialVersionUID = 0L;
            private final SessionHandle sessionHandle$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RSC client is executing register session ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sessionHandle$3}));
            }
            {
                this.sessionHandle$3 = sessionHandle$3;
            }
        });
        this.livySession.recordActivity();
        return this.rscClient().submit((Job)new RegisterSessionJob(this.sessionId(sessionHandle)));
    }

    public JobHandle<?> executeUnregisterSession(SessionHandle sessionHandle) throws Exception {
        this.info((Function0<Object>)new Serializable(this, sessionHandle){
            public static final long serialVersionUID = 0L;
            private final SessionHandle sessionHandle$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RSC client is executing unregister session ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sessionHandle$2}));
            }
            {
                this.sessionHandle$2 = sessionHandle$2;
            }
        });
        this.livySession.recordActivity();
        return this.rscClient().submit((Job)new UnregisterSessionJob(this.sessionId(sessionHandle)));
    }

    public RpcClient(InteractiveSession livySession) {
        this.livySession = livySession;
        Logging.class.$init$((Logging)this);
        this.defaultIncrementalCollect = ((Object)BoxesRunTime.boxToBoolean((boolean)livySession.livyConf().getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_INCR_COLLECT_ENABLED()))).toString();
        this.rscClient = (RSCClient)livySession.client().get();
    }
}

