/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.driver;

import java.io.File;
import java.lang.reflect.Method;
import org.apache.livy.JobContext;
import org.apache.livy.rsc.Utils;
import org.apache.livy.rsc.driver.RSCDriver;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.hive.HiveContext;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobContextImpl
implements JobContext {
    private static final Logger LOG = LoggerFactory.getLogger(JobContextImpl.class);
    private final JavaSparkContext sc;
    private final File localTmpDir;
    private volatile SQLContext sqlctx;
    private volatile HiveContext hivectx;
    private volatile JavaStreamingContext streamingctx;
    private final RSCDriver driver;
    private volatile Object sparksession;

    public JobContextImpl(JavaSparkContext sc, File localTmpDir, RSCDriver driver) {
        this.sc = sc;
        this.localTmpDir = localTmpDir;
        this.driver = driver;
    }

    public JavaSparkContext sc() {
        return this.sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sparkSession() throws Exception {
        if (this.sparksession == null) {
            JobContextImpl jobContextImpl = this;
            synchronized (jobContextImpl) {
                if (this.sparksession == null) {
                    try {
                        Class<?> clz = Class.forName("org.apache.spark.sql.SparkSession$");
                        Object spark = clz.getField("MODULE$").get(null);
                        Method m = clz.getMethod("builder", new Class[0]);
                        Object builder = m.invoke(spark, new Object[0]);
                        builder.getClass().getMethod("sparkContext", SparkContext.class).invoke(builder, this.sc.sc());
                        this.sparksession = builder.getClass().getMethod("getOrCreate", new Class[0]).invoke(builder, new Object[0]);
                    }
                    catch (Exception e) {
                        LOG.warn("SparkSession is not supported", (Throwable)e);
                        throw e;
                    }
                }
            }
        }
        return this.sparksession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLContext sqlctx() {
        if (this.sqlctx == null) {
            JobContextImpl jobContextImpl = this;
            synchronized (jobContextImpl) {
                if (this.sqlctx == null) {
                    this.sqlctx = new SQLContext(this.sc);
                }
            }
        }
        return this.sqlctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveContext hivectx() {
        if (this.hivectx == null) {
            JobContextImpl jobContextImpl = this;
            synchronized (jobContextImpl) {
                if (this.hivectx == null) {
                    this.hivectx = new HiveContext(this.sc.sc());
                }
            }
        }
        return this.hivectx;
    }

    public synchronized JavaStreamingContext streamingctx() {
        Utils.checkState(this.streamingctx != null, "method createStreamingContext must be called first.", new Object[0]);
        return this.streamingctx;
    }

    public synchronized void createStreamingContext(long batchDuration) {
        Utils.checkState(this.streamingctx == null, "Streaming context is not null.", new Object[0]);
        this.streamingctx = new JavaStreamingContext(this.sc, new Duration(batchDuration));
    }

    public synchronized void stopStreamingCtx() {
        Utils.checkState(this.streamingctx != null, "Streaming Context is null", new Object[0]);
        this.streamingctx.stop();
        this.streamingctx = null;
    }

    public File getLocalTmpDir() {
        return this.localTmpDir;
    }

    public synchronized void stop() {
        if (this.streamingctx != null) {
            this.stopStreamingCtx();
        }
        if (this.sc != null) {
            this.sc.stop();
        }
    }

    public void addFile(String path) {
        this.driver.addFile(path);
    }

    public void addJarOrPyFile(String path) throws Exception {
        this.driver.addJarOrPyFile(path);
    }
}

