import { ContentType, WorkspaceEdit, ResourceContent, ResourceContentRequest, ResourceListRequest, ResourcesList } from "@kie-tools-core/workspace/dist/api";
import { EditorContent, EditorTheme, KogitoEditorChannelApi, StateControlCommand } from "@kie-tools-core/editor/dist/api";
import { EmbeddedEditorFile, StateControl } from "@kie-tools-core/editor/dist/channel";
import { Notification } from "@kie-tools-core/notifications/dist/api";
export declare class StandaloneEditorsEditorChannelApiImpl implements KogitoEditorChannelApi {
    private readonly stateControl;
    private readonly file;
    private readonly locale;
    private readonly overrides;
    private readonly resources?;
    constructor(stateControl: StateControl, file: EmbeddedEditorFile, locale: string, overrides: Partial<KogitoEditorChannelApi>, resources?: Map<string, {
        contentType: ContentType;
        content: Promise<string>;
    }> | undefined);
    kogitoWorkspace_newEdit(edit: WorkspaceEdit): void;
    kogitoEditor_stateControlCommandUpdate(command: StateControlCommand): void;
    kogitoEditor_contentRequest(): Promise<{
        content: string;
        normalizedPosixPathRelativeToTheWorkspaceRoot: string;
    }>;
    kogitoWorkspace_resourceContentRequest(request: ResourceContentRequest): Promise<ResourceContent>;
    kogitoWorkspace_resourceListRequest(request: ResourceListRequest): Promise<ResourcesList>;
    kogitoWorkspace_openFile(normalizedPosixPathRelativeToTheWorkspaceRoot: string): void;
    kogitoEditor_ready(): void;
    kogitoEditor_theme(): import("@kie-tools-core/envelope-bus/dist/api").SharedValueProvider<EditorTheme>;
    kogitoEditor_setContentError(editorContent: EditorContent): void;
    kogitoI18n_getLocale(): Promise<string>;
    kogitoNotifications_createNotification(notification: Notification): void;
    kogitoNotifications_setNotifications(normalizedPosixPathRelativeToTheWorkspaceRoot: string, notifications: Notification[]): void;
    kogitoNotifications_removeNotifications(normalizedPosixPathRelativeToTheWorkspaceRoot: string): void;
}
//# sourceMappingURL=StandaloneEditorsEditorChannelApiImpl.d.ts.map