/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

plugins {
    id("java-library")
    id("maven-publish")
    id("org.jreleaser") version ("1.14.0")
    id("checkstyle")
}

group = "org.apache.iggy"
version = "0.5.0"

repositories {
    mavenCentral()
}

java {
    withJavadocJar()
    withSourcesJar()
}

checkstyle {
    toolVersion = "10.23.1"
    configFile = file("../dev-support/checkstyle/checkstyle.xml")
}

dependencies {
    implementation("org.apache.httpcomponents.client5:httpclient5:5.4")
    implementation("com.fasterxml.jackson.core:jackson-databind:2.18.0")
    implementation("com.fasterxml.jackson.datatype:jackson-datatype-jdk8:2.18.0")
    implementation("org.apache.commons:commons-lang3:3.17.0")
    implementation("org.slf4j:slf4j-api:2.0.16")
    implementation("com.google.code.findbugs:jsr305:3.0.2")
    implementation("io.projectreactor:reactor-core:3.6.11")
    implementation("io.projectreactor.netty:reactor-netty-core:1.1.23")
    testImplementation("org.testcontainers:testcontainers:1.20.3")
    testImplementation("org.testcontainers:junit-jupiter:1.20.3")
    testImplementation(platform("org.junit:junit-bom:5.11.3"))
    testImplementation("org.junit.jupiter:junit-jupiter")
    testImplementation("org.assertj:assertj-core:3.26.3")
    testRuntimeOnly("ch.qos.logback:logback-classic:1.5.11")
    testRuntimeOnly("io.netty:netty-resolver-dns-native-macos:4.2.1.Final:osx-aarch_64")
}

tasks.withType<Test> {
    useJUnitPlatform()
}

publishing {
    publications {
        create<MavenPublication>("maven") {
            groupId = "org.apache.iggy"
            artifactId = "iggy-java-sdk"
            version = "0.5.0"

            from(components["java"])

            pom {
                name = "Apache Iggy Java Client SDK"
                description = "Official Java client SDK for Apache Iggy.\n" +
                        "Apache Iggy (Incubating) is an effort undergoing incubation at the Apache Software Foundation (ASF), " +
                        "sponsored by the Apache Incubator PMC."
                url = "https://github.com/apache/iggy"
                packaging = "jar"
                licenses {
                    license {
                        name = "Apache License, Version 2.0"
                        url = "https://www.apache.org/licenses/LICENSE-2.0.txt"
                    }
                }
                developers {
                    developer {
                        name = "Apache Iggy"
                        email = "dev@iggy.apache.org"
                    }
                    scm {
                        url = "https://github.com/apache/iggy"
                        connection = "scm:git:git://github.com/apache/iggy.git"
                        developerConnection = "scm:git:git://github.com/apache/iggy.git"
                    }
                }
            }
        }
    }

    repositories {
        maven {
            val releasesRepoUrl = "https://repository.apache.org/service/local/staging/deploy/maven2"
            val snapshotsRepoUrl = "https://repository.apache.org/content/repositories/snapshots/"

            url = uri(if ((version as String).endsWith("SNAPSHOT")) snapshotsRepoUrl else releasesRepoUrl)

            credentials {
                username = System.getenv("NEXUS_USER")
                password = System.getenv("NEXUS_PASSWORD")
            }
        }
    }
}
