/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.apache.hugegraph.util;

import java.time.Duration;
import java.util.Date;

public final class TimeUtil {

    @SuppressWarnings("deprecation")
    public static long BASE_TIME = new Date(2017 - 1900, 10, 28).getTime();

    public static long timeGen() {
        return System.currentTimeMillis() - BASE_TIME;
    }

    public static long timeGen(Date date) {
        return date.getTime() - BASE_TIME;
    }

    public static long timeGen(long time) {
        return time - BASE_TIME;
    }

    public static long tillNextMillis(long lastTimestamp) {
        long timestamp = timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = timeGen();
        }
        return timestamp;
    }

    public static String readableTime(long time) {
        if (time > 60 * 1000) {
            // Remove the milliseconds part
            time = time / 1000 * 1000;
        }
        Duration duration = Duration.ofMillis(time);
        return duration.toString()
                       .substring(2)
                       .replaceAll("(\\d[HMS])(?!$)", "$1 ")
                       .toLowerCase();
    }
}
