## 4. 任务执行规范

本规范定义了 AI 助手在执行具体编码任务时必须遵循的流程和标准，确保每一步操作都清晰、可追溯，并与整体工作流保持一致。

### 核心原则

- **一次只做一个任务**: 严格遵循任务清单，每次只执行一个原子任务。
- **文档驱动**: 依照`tasks.md`, 同时所有执行都必须以`requirements.md`和`design.md`为依据。
- **小步快跑**: 鼓励为每个小任务创建独立的、可审查的提交。

---

### 执行工作流 (Execution Workflow)

#### 阶段一: 准备阶段 (Preparation)

1.  **前置检查**:
    - **确认上下文**: 在开始前，必须再次确认相关的需求和设计文档已阅读并理解。
    - **检查依赖**: 查看`tasks.md`，确认当前任务的所有前置依赖任务都已标记为完成。如果依赖未完成，必须暂停并向用户报告。

#### 阶段二: 执行阶段 (Execution)

1.  **研究与编码**:

    - **代码风格一致性**: **必须**首先阅读目标文件或模块的现有代码，以理解并遵循项目既有的代码风格、命名规范和错误处理策略。
    - **TDD 优先**: 如果任务是 TDD 测试用例，先编写失败的测试；如果是功能实现，则使其通过测试。
    - **聚焦任务**: 只编写当前任务所需的最少代码。**严禁**实现范围之外的功能。

2.  **代码自检**:
    - 在编码初步完成后，**必须**进行代码的自我审查，确保：
      - 逻辑符合任务需求和设计文档。
      - 代码整洁，无明显的坏味道。
      - 遵循了项目的代码风格。

#### 阶段三: 完成阶段 (Completion)

1.  **定义完成 (Definition of Done)**:

    - 一个任务只有在满足以下所有条件后，才能被视为“完成”：
      - **A. 代码已实现**: 核心功能代码已根据设计文档编写完毕。
      - **B. 测试已通过**: 相关的单元测试或集成测试已编写并通过。
      - **C. 状态已更新**: `tasks.md`中的对应任务已被标记为完成。
      - **D. 日志已记录**: 执行过程的关键决策和产出已记录到日志中。

2.  **收尾操作**:
    1. **更新任务清单**: 在`.workflow/{feature_name}/tasks.md`文件中，将已完成任务的复选框标记为`[x]`。
    2. **记录执行日志**: 在`.workflow/{feature_name}/logs/`目录下，为当前任务生成或追加日志文件，记录关键操作和代码片段。
    - **暂停并报告**: 在完成以上所有步骤后，**必须暂停**，并向用户报告任务已完成。**严禁自动开始下一个任务。**

### 特殊情况处理

- **工具失败**: 如果某个工具（如代码编辑、文件搜索）连续失败 2-3 次，必须停止尝试，并向用户清晰地报告问题、已尝试的解决方案及求助请求。
- **需求/设计疑问**: 如果在执行过程中对需求或设计产生疑问，**必须立即暂停**，并向用户提问澄清。
