/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class PersonalRankTraverser
extends HugeTraverser {
    private final double alpha;
    private final long degree;
    private final int maxDepth;

    public PersonalRankTraverser(HugeGraph graph, double alpha, long degree, int maxDepth) {
        super(graph);
        this.alpha = alpha;
        this.degree = degree;
        this.maxDepth = maxDepth;
    }

    public Map<Id, Double> personalRank(Id source, String label, WithLabel withLabel) {
        E.checkNotNull((Object)source, (String)"source vertex id");
        this.checkVertexExist(source, "source vertex");
        E.checkArgumentNotNull((Object)label, (String)"The edge label can't be null", (Object[])new Object[0]);
        Map<Id, Double> ranks = PersonalRankTraverser.newMap();
        ranks.put(source, 1.0);
        Id labelId = this.graph().edgeLabel(label).id();
        Directions dir = this.getStartDirection(source, label);
        Set<Id> outSeeds = PersonalRankTraverser.newIdSet();
        Set<Id> inSeeds = PersonalRankTraverser.newIdSet();
        if (dir == Directions.OUT) {
            outSeeds.add(source);
        } else {
            inSeeds.add(source);
        }
        Set<Id> rootAdjacencies = PersonalRankTraverser.newIdSet();
        for (long i = 0L; i < (long)this.maxDepth; ++i) {
            Map<Id, Double> newRanks = this.calcNewRanks(outSeeds, inSeeds, labelId, ranks);
            ranks = this.compensateRoot(source, newRanks);
            if (i != 0L) continue;
            rootAdjacencies.addAll(ranks.keySet());
        }
        PersonalRankTraverser.removeAll(ranks, rootAdjacencies);
        if (withLabel == WithLabel.SAME_LABEL) {
            PersonalRankTraverser.removeAll(ranks, dir == Directions.OUT ? inSeeds : outSeeds);
        } else if (withLabel == WithLabel.OTHER_LABEL) {
            PersonalRankTraverser.removeAll(ranks, dir == Directions.OUT ? outSeeds : inSeeds);
        }
        return ranks;
    }

    private Map<Id, Double> calcNewRanks(Set<Id> outSeeds, Set<Id> inSeeds, Id label, Map<Id, Double> ranks) {
        Map<Id, Double> newRanks = PersonalRankTraverser.newMap();
        BiFunction<Set, Directions, Set> neighborIncrRanks = (seeds, dir) -> {
            Set<Id> tmpSeeds = PersonalRankTraverser.newIdSet();
            for (Id seed : seeds) {
                Double oldRank = (Double)ranks.get(seed);
                E.checkState((oldRank != null ? 1 : 0) != 0, (String)"Expect rank of seed exists", (Object[])new Object[0]);
                Iterator<Id> iter = this.adjacentVertices(seed, (Directions)dir, label, this.degree);
                List neighbors = IteratorUtils.list(iter);
                long degree = neighbors.size();
                if (degree == 0L) {
                    newRanks.put(seed, oldRank);
                    continue;
                }
                double incrRank = oldRank * this.alpha / (double)degree;
                for (Id neighbor : neighbors) {
                    tmpSeeds.add(neighbor);
                    double rank = newRanks.getOrDefault(neighbor, 0.0);
                    newRanks.put(neighbor, rank + incrRank);
                }
            }
            return tmpSeeds;
        };
        Set tmpInSeeds = neighborIncrRanks.apply(outSeeds, Directions.OUT);
        Set tmpOutSeeds = neighborIncrRanks.apply(inSeeds, Directions.IN);
        outSeeds.addAll(tmpOutSeeds);
        inSeeds.addAll(tmpInSeeds);
        return newRanks;
    }

    private Map<Id, Double> compensateRoot(Id root, Map<Id, Double> newRanks) {
        double rank = newRanks.getOrDefault(root, 0.0);
        newRanks.put(root, rank += 1.0 - this.alpha);
        return newRanks;
    }

    private Directions getStartDirection(Id source, String label) {
        HugeVertex vertex = (HugeVertex)this.graph().vertices(source).next();
        VertexLabel vertexLabel = vertex.schemaLabel();
        EdgeLabel edgeLabel = this.graph().edgeLabel(label);
        Id sourceLabel = edgeLabel.sourceLabel();
        Id targetLabel = edgeLabel.targetLabel();
        E.checkArgument((boolean)edgeLabel.linkWithLabel(vertexLabel.id()), (String)"The vertex '%s' doesn't link with edge label '%s'", (Object[])new Object[]{source, label});
        E.checkArgument((!sourceLabel.equals(targetLabel) ? 1 : 0) != 0, (String)"The edge label for personal rank must link different vertex labels", (Object[])new Object[0]);
        if (sourceLabel.equals(vertexLabel.id())) {
            return Directions.OUT;
        }
        assert (targetLabel.equals(vertexLabel.id()));
        return Directions.IN;
    }

    private static void removeAll(Map<Id, Double> map, Set<Id> keys) {
        for (Id key : keys) {
            map.remove(key);
        }
    }

    public static enum WithLabel {
        SAME_LABEL,
        OTHER_LABEL,
        BOTH_LABEL;

    }
}

