/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.id.SplicingIdGenerator;
import org.apache.hugegraph.backend.serializer.BytesBuffer;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.structure.GraphType;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.HashUtil;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.NumericUtil;

public class HugeIndex
implements GraphType,
Cloneable {
    private final HugeGraph graph;
    private Object fieldValues;
    private IndexLabel indexLabel;
    private Set<IdWithExpiredTime> elementIds;

    public HugeIndex(HugeGraph graph, IndexLabel indexLabel) {
        E.checkNotNull((Object)graph, (String)"graph");
        E.checkNotNull((Object)indexLabel, (String)"label");
        E.checkNotNull((Object)indexLabel.id(), (String)"label id");
        this.graph = graph;
        this.indexLabel = indexLabel;
        this.elementIds = new LinkedHashSet<IdWithExpiredTime>();
        this.fieldValues = null;
    }

    @Override
    public String name() {
        return this.indexLabel.name();
    }

    @Override
    public HugeType type() {
        if (this.indexLabel == IndexLabel.label(HugeType.VERTEX)) {
            return HugeType.VERTEX_LABEL_INDEX;
        }
        if (this.indexLabel == IndexLabel.label(HugeType.EDGE)) {
            return HugeType.EDGE_LABEL_INDEX;
        }
        return this.indexLabel.indexType().type();
    }

    public HugeGraph graph() {
        return this.graph;
    }

    public Id id() {
        return HugeIndex.formatIndexId(this.type(), this.indexLabelId(), this.fieldValues());
    }

    public Id hashId() {
        return HugeIndex.formatIndexHashId(this.type(), this.indexLabelId(), this.fieldValues());
    }

    public Object fieldValues() {
        return this.fieldValues;
    }

    public void fieldValues(Object fieldValues) {
        this.fieldValues = fieldValues;
    }

    public Id indexLabelId() {
        return this.indexLabel.id();
    }

    public IndexLabel indexLabel() {
        return this.indexLabel;
    }

    public IdWithExpiredTime elementIdWithExpiredTime() {
        E.checkState((this.elementIds.size() == 1 ? 1 : 0) != 0, (String)"Expect one element id, actual %s", (Object[])new Object[]{this.elementIds.size()});
        return this.elementIds.iterator().next();
    }

    public Id elementId() {
        return this.elementIdWithExpiredTime().id();
    }

    public Set<Id> elementIds() {
        Set ids = InsertionOrderUtil.newSet((int)this.elementIds.size());
        for (IdWithExpiredTime idWithExpiredTime : this.elementIds) {
            ids.add(idWithExpiredTime.id());
        }
        return Collections.unmodifiableSet(ids);
    }

    public Set<IdWithExpiredTime> expiredElementIds() {
        long now = this.graph.now();
        Set expired = InsertionOrderUtil.newSet();
        for (IdWithExpiredTime id : this.elementIds) {
            if (0L >= id.expiredTime || id.expiredTime >= now) continue;
            expired.add(id);
        }
        this.elementIds.removeAll(expired);
        return expired;
    }

    public void elementIds(Id elementId) {
        this.elementIds(elementId, 0L);
    }

    public void elementIds(Id elementId, long expiredTime) {
        this.elementIds.add(new IdWithExpiredTime(elementId, expiredTime));
    }

    public void resetElementIds() {
        this.elementIds = new LinkedHashSet<IdWithExpiredTime>();
    }

    public long expiredTime() {
        return this.elementIdWithExpiredTime().expiredTime();
    }

    public boolean hasTtl() {
        if (this.indexLabel.system()) {
            return false;
        }
        return this.indexLabel.baseLabel().ttl() > 0L;
    }

    public long ttl() {
        return this.expiredTime() - this.graph.now();
    }

    public HugeIndex clone() {
        try {
            return (HugeIndex)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HugeException("Failed to clone HugeIndex", e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HugeIndex)) {
            return false;
        }
        HugeIndex other = (HugeIndex)obj;
        return this.id().equals(other.id());
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public String toString() {
        return String.format("{label=%s<%s>, fieldValues=%s, elementIds=%s}", this.indexLabel.name(), this.indexLabel.indexType().string(), this.fieldValues, this.elementIds);
    }

    public static Id formatIndexHashId(HugeType type, Id indexLabel, Object fieldValues) {
        E.checkState((!type.isRangeIndex() ? 1 : 0) != 0, (String)"RangeIndex can't return a hash id", (Object[])new Object[0]);
        String value = fieldValues == null ? "" : fieldValues.toString();
        return HugeIndex.formatIndexId(type, indexLabel, HashUtil.hash((String)value));
    }

    public static Id formatIndexId(HugeType type, Id indexLabelId, Object fieldValues) {
        if (type.isStringIndex()) {
            String value = "";
            if (fieldValues instanceof Id) {
                value = IdGenerator.asStoredString((Id)fieldValues);
            } else if (fieldValues != null) {
                value = fieldValues.toString();
            }
            String strIndexLabelId = IdGenerator.asStoredString(indexLabelId);
            return SplicingIdGenerator.splicing(strIndexLabelId, value);
        }
        assert (type.isRangeIndex());
        int length = type.isRange4Index() ? 4 : 8;
        BytesBuffer buffer = BytesBuffer.allocate(4 + length);
        buffer.writeInt(SchemaElement.schemaId(indexLabelId));
        if (fieldValues != null) {
            E.checkState((boolean)(fieldValues instanceof Number), (String)"Field value of range index must be number: %s", (Object[])new Object[]{fieldValues.getClass().getSimpleName()});
            byte[] bytes = HugeIndex.number2bytes((Number)fieldValues);
            buffer.write(bytes);
        }
        return buffer.asId();
    }

    public static HugeIndex parseIndexId(HugeGraph graph, HugeType type, byte[] id) {
        Object values;
        IndexLabel indexLabel;
        if (type.isStringIndex()) {
            Id idObject = IdGenerator.of(id, Id.IdType.STRING);
            String[] parts = SplicingIdGenerator.parse(idObject);
            E.checkState((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid secondary index id", (Object[])new Object[0]);
            Id label = IdGenerator.ofStoredString(parts[0], Id.IdType.LONG);
            indexLabel = IndexLabel.label(graph, label);
            values = parts[1];
        } else {
            assert (type.isRange4Index() || type.isRange8Index());
            int labelLength = 4;
            E.checkState((id.length > 4 ? 1 : 0) != 0, (String)"Invalid range index id", (Object[])new Object[0]);
            BytesBuffer buffer = BytesBuffer.wrap(id);
            Id label = IdGenerator.of(buffer.readInt());
            indexLabel = IndexLabel.label(graph, label);
            List<Id> fields = indexLabel.indexFields();
            E.checkState((fields.size() == 1 ? 1 : 0) != 0, (String)"Invalid range index fields", (Object[])new Object[0]);
            DataType dataType = graph.propertyKey(fields.get(0)).dataType();
            E.checkState((dataType.isNumber() || dataType.isDate() ? 1 : 0) != 0, (String)"Invalid range index field type", (Object[])new Object[0]);
            Class<?> clazz = dataType.isNumber() ? dataType.clazz() : DataType.LONG.clazz();
            values = HugeIndex.bytes2number(buffer.read(id.length - 4), clazz);
        }
        HugeIndex index = new HugeIndex(graph, indexLabel);
        index.fieldValues(values);
        return index;
    }

    public static byte[] number2bytes(Number number) {
        if (number instanceof Byte) {
            number = number.intValue();
        }
        return NumericUtil.numberToSortableBytes((Number)number);
    }

    public static Number bytes2number(byte[] bytes, Class<?> clazz) {
        return NumericUtil.sortableBytesToNumber((byte[])bytes, clazz);
    }

    public static class IdWithExpiredTime {
        private Id id;
        private long expiredTime;

        public IdWithExpiredTime(Id id, long expiredTime) {
            this.id = id;
            this.expiredTime = expiredTime;
        }

        public Id id() {
            return this.id;
        }

        public long expiredTime() {
            return this.expiredTime;
        }

        public String toString() {
            return String.format("%s(%s)", this.id, this.expiredTime);
        }
    }
}

