/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.schema;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.builder.SchemaBuilder;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.Propertiable;
import org.apache.hugegraph.type.define.AggregateType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.type.define.WriteType;
import org.apache.hugegraph.util.Blob;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.LongEncoding;

public class PropertyKey
extends SchemaElement
implements Propertiable {
    private DataType dataType = DataType.TEXT;
    private Cardinality cardinality = Cardinality.SINGLE;
    private AggregateType aggregateType = AggregateType.NONE;
    private WriteType writeType = WriteType.OLTP;

    public PropertyKey(HugeGraph graph, Id id, String name) {
        super(graph, id, name);
    }

    @Override
    public HugeType type() {
        return HugeType.PROPERTY_KEY;
    }

    public DataType dataType() {
        return this.dataType;
    }

    public void dataType(DataType dataType) {
        this.dataType = dataType;
    }

    public Cardinality cardinality() {
        return this.cardinality;
    }

    public void cardinality(Cardinality cardinality) {
        this.cardinality = cardinality;
    }

    public AggregateType aggregateType() {
        return this.aggregateType;
    }

    public void aggregateType(AggregateType aggregateType) {
        this.aggregateType = aggregateType;
    }

    public void writeType(WriteType writeType) {
        this.writeType = writeType;
    }

    public WriteType writeType() {
        return this.writeType;
    }

    public boolean oltp() {
        return this.writeType.oltp();
    }

    public boolean olap() {
        return this.writeType.olap();
    }

    @Override
    public Set<Id> properties() {
        return Collections.emptySet();
    }

    public PropertyKey properties(Id ... properties) {
        if (properties.length > 0) {
            throw new NotSupportException("PropertyKey.properties(Id)");
        }
        return this;
    }

    public void defineDefaultValue(Object value) {
        this.userdata().put("~default_value", value);
    }

    public Object defaultValue() {
        return this.userdata().get("~default_value");
    }

    public boolean hasSameContent(PropertyKey other) {
        return super.hasSameContent(other) && this.dataType == other.dataType() && this.cardinality == other.cardinality() && this.aggregateType == other.aggregateType() && this.writeType == other.writeType();
    }

    public String clazz() {
        String dataType = this.dataType().clazz().getSimpleName();
        switch (this.cardinality) {
            case SINGLE: {
                return dataType;
            }
            case SET: {
                return String.format("Set<%s>", dataType);
            }
            case LIST: {
                return String.format("List<%s>", dataType);
            }
        }
        throw new AssertionError((Object)String.format("Unsupported cardinality: '%s'", this.cardinality));
    }

    public Class<?> implementClazz() {
        Class cls;
        switch (this.cardinality) {
            case SINGLE: {
                cls = this.dataType().clazz();
                break;
            }
            case SET: {
                cls = LinkedHashSet.class;
                break;
            }
            case LIST: {
                cls = ArrayList.class;
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported cardinality: '%s'", this.cardinality));
            }
        }
        return cls;
    }

    public <T> T newValue() {
        switch (this.cardinality) {
            case SET: {
                return (T)new LinkedHashSet();
            }
            case LIST: {
                return (T)new ArrayList();
            }
        }
        try {
            return (T)this.implementClazz().newInstance();
        }
        catch (Exception e) {
            throw new HugeException("Failed to new instance of %s: %s", this.implementClazz(), e.toString());
        }
    }

    public <V> boolean checkValueType(V value) {
        boolean valid;
        switch (this.cardinality) {
            case SINGLE: {
                valid = this.checkDataType(value);
                break;
            }
            case SET: {
                valid = value instanceof Set;
                valid = valid && this.checkDataType((Set)value);
                break;
            }
            case LIST: {
                valid = value instanceof List;
                valid = valid && this.checkDataType((List)value);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported cardinality: '%s'", this.cardinality));
            }
        }
        return valid;
    }

    private <V> boolean checkDataType(V value) {
        return this.dataType().clazz().isInstance(value);
    }

    private <V> boolean checkDataType(Collection<V> values) {
        boolean valid = true;
        for (V o : values) {
            if (this.checkDataType(o)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public <V> Object serialValue(V value, boolean encodeNumber) {
        V validValue = this.validValue(value);
        E.checkArgument((validValue != null ? 1 : 0) != 0, (String)"Invalid property value '%s' for key '%s'", (Object[])new Object[]{value, this.name()});
        E.checkArgument((boolean)this.cardinality.single(), (String)"The cardinality can't be '%s' for navigation key '%s'", (Object[])new Object[]{this.cardinality, this.name()});
        if (this.dataType.isNumber() || this.dataType.isDate()) {
            if (encodeNumber) {
                return LongEncoding.encodeNumber(validValue);
            }
            return validValue.toString();
        }
        return validValue;
    }

    public <V> V validValueOrThrow(V value) {
        V validValue = this.validValue(value);
        if (validValue == null) {
            E.checkArgument((boolean)false, (String)"Invalid property value '%s' for key '%s', expect a value of type %s, actual type %s", (Object[])new Object[]{value, this.name(), this.clazz(), value.getClass().getSimpleName()});
        }
        return validValue;
    }

    public <V> V validValue(V value) {
        try {
            return this.convValue(value);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Invalid property value '%s' for key '%s': %s", value, this.name(), e.getMessage()));
        }
    }

    private <V, T> V convValue(V value) {
        if (value == null) {
            return null;
        }
        if (this.checkValueType(value)) {
            return value;
        }
        AbstractCollection validValue = null;
        if (this.cardinality.single()) {
            validValue = (AbstractCollection)this.convSingleValue(value);
        } else if (value instanceof Collection) {
            AbstractCollection validValues;
            assert (this.cardinality.multiple());
            Collection collection = (Collection)value;
            if (value instanceof Set) {
                validValues = new LinkedHashSet(collection.size());
            } else {
                assert (value instanceof List);
                validValues = new ArrayList(collection.size());
            }
            for (Object element : collection) {
                if ((element = this.convSingleValue(element)) == null) {
                    validValues = null;
                    break;
                }
                validValues.add(element);
            }
            validValue = validValues;
        } else {
            assert (this.cardinality.multiple());
            E.checkArgument((boolean)false, (String)"Property value must be %s, but got '%s'(%s)", (Object[])new Object[]{this.cardinality, value, value.getClass().getSimpleName()});
        }
        return (V)validValue;
    }

    private <V> V convSingleValue(V value) {
        if (value == null) {
            return null;
        }
        if (this.dataType().isNumber()) {
            Number number = this.dataType().valueToNumber(value);
            return (V)number;
        }
        if (this.dataType().isDate()) {
            Date date = this.dataType().valueToDate(value);
            return (V)date;
        }
        if (this.dataType().isUUID()) {
            UUID uuid = this.dataType().valueToUUID(value);
            return (V)uuid;
        }
        if (this.dataType().isBlob()) {
            Blob blob = this.dataType().valueToBlob(value);
            return (V)blob;
        }
        if (this.checkDataType(value)) {
            return value;
        }
        return null;
    }

    public static interface Builder
    extends SchemaBuilder<PropertyKey> {
        public SchemaElement.TaskWithSchema createWithTask();

        public Builder asText();

        public Builder asInt();

        public Builder asDate();

        public Builder asUUID();

        public Builder asBoolean();

        public Builder asByte();

        public Builder asBlob();

        public Builder asDouble();

        public Builder asFloat();

        public Builder asLong();

        public Builder valueSingle();

        public Builder valueList();

        public Builder valueSet();

        public Builder calcMax();

        public Builder calcMin();

        public Builder calcSum();

        public Builder calcOld();

        public Builder calcSet();

        public Builder calcList();

        public Builder writeType(WriteType var1);

        public Builder cardinality(Cardinality var1);

        public Builder dataType(DataType var1);

        public Builder aggregateType(AggregateType var1);

        public Builder userdata(String var1, Object var2);

        public Builder userdata(Map<String, Object> var1);
    }
}

