/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.raft;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.alipay.sofa.jraft.util.CRC64;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.Checksum;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.backend.store.raft.RaftBackendStore;
import org.apache.hugegraph.backend.store.raft.RaftException;
import org.apache.hugegraph.backend.store.raft.compress.CompressStrategyManager;
import org.apache.hugegraph.testutil.Whitebox;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class StoreSnapshotFile {
    private static final Logger LOG = Log.logger(StoreSnapshotFile.class);
    public static final String SNAPSHOT_DIR = "snapshot";
    private static final String TAR = ".zip";
    private final RaftBackendStore[] stores;
    private final Map<String, String> dataDisks;
    private final AtomicBoolean compressing;

    public StoreSnapshotFile(RaftBackendStore[] stores) {
        this.stores = stores;
        this.dataDisks = new HashMap<String, String>();
        for (RaftBackendStore raftStore : stores) {
            this.dataDisks.putAll((Map)Whitebox.invoke((Object)raftStore, (String)"store", (String)"reportDiskMapping", (Object[])new Object[0]));
        }
        this.compressing = new AtomicBoolean(false);
        LOG.debug("The store data disks mapping {}", this.dataDisks);
    }

    public void save(SnapshotWriter writer, Closure done, ExecutorService executor) {
        try {
            Map<String, String> snapshotDirMaps = this.doSnapshotSave();
            executor.execute(() -> {
                if (!this.compressing.compareAndSet(false, true)) {
                    LOG.info("Last compress task doesn't finish, skipped it");
                    done.run(new Status(RaftError.EBUSY, "Last compress task doesn't finish, skipped it", new Object[0]));
                    return;
                }
                try {
                    this.compressSnapshotDir(writer, snapshotDirMaps);
                    this.deleteSnapshotDirs(snapshotDirMaps.keySet());
                    done.run(Status.OK());
                }
                catch (Throwable e) {
                    LOG.error("Failed to compress snapshot", e);
                    done.run(new Status(RaftError.EIO, "Failed to compress snapshot, error is %s", new Object[]{e.getMessage()}));
                }
                finally {
                    this.compressing.compareAndSet(true, false);
                }
            });
        }
        catch (Throwable e) {
            LOG.error("Failed to save snapshot", e);
            done.run(new Status(RaftError.EIO, "Failed to save snapshot, error is %s", new Object[]{e.getMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(SnapshotReader reader) {
        Set snapshotDirTars = reader.listFiles();
        LOG.info("The snapshot tar files to be loaded are {}", (Object)snapshotDirTars);
        HashSet<String> snapshotDirs = new HashSet<String>();
        if (!this.compressing.compareAndSet(false, true)) {
            LOG.info("Last decompress task doesn't finish, skipped it");
            return false;
        }
        try {
            for (String snapshotDirTar : snapshotDirTars) {
                String snapshotDir = this.decompressSnapshot(reader, snapshotDirTar);
                snapshotDirs.add(snapshotDir);
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to decompress snapshot tar", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.compressing.compareAndSet(true, false);
        }
        try {
            this.doSnapshotLoad();
            this.deleteSnapshotDirs(snapshotDirs);
        }
        catch (Throwable e) {
            LOG.error("Failed to load snapshot", e);
            return false;
        }
        return true;
    }

    private Map<String, String> doSnapshotSave() {
        Map snapshotDirMaps = InsertionOrderUtil.newMap();
        for (RaftBackendStore store : this.stores) {
            snapshotDirMaps.putAll(store.originStore().createSnapshot(SNAPSHOT_DIR));
        }
        LOG.info("Saved all snapshots: {}", (Object)snapshotDirMaps);
        return snapshotDirMaps;
    }

    private void doSnapshotLoad() {
        for (RaftBackendStore store : this.stores) {
            store.originStore().resumeSnapshot(SNAPSHOT_DIR, false);
        }
    }

    private void compressSnapshotDir(SnapshotWriter writer, Map<String, String> snapshotDirMaps) {
        String writerPath = writer.getPath();
        for (Map.Entry<String, String> entry : snapshotDirMaps.entrySet()) {
            String snapshotDir = entry.getKey();
            String diskTableKey = entry.getValue();
            String snapshotDirTar = Paths.get(snapshotDir, new String[0]).getFileName().toString() + TAR;
            String outputFile = Paths.get(writerPath, snapshotDirTar).toString();
            CRC64 checksum = new CRC64();
            try {
                LOG.info("Prepare to compress dir '{}' to '{}'", (Object)snapshotDir, (Object)outputFile);
                long begin = System.currentTimeMillis();
                String rootDir = Paths.get(snapshotDir, new String[0]).toAbsolutePath().getParent().toString();
                String sourceDir = Paths.get(snapshotDir, new String[0]).getFileName().toString();
                CompressStrategyManager.getDefault().compressZip(rootDir, sourceDir, outputFile, (Checksum)checksum);
                long end = System.currentTimeMillis();
                LOG.info("Compressed dir '{}' to '{}', took {} seconds", new Object[]{snapshotDir, outputFile, Float.valueOf((float)(end - begin) / 1000.0f)});
            }
            catch (Throwable e) {
                throw new RaftException("Failed to compress snapshot, path=%s, files=%s", e, writerPath, snapshotDirMaps.keySet());
            }
            LocalFileMetaOutter.LocalFileMeta.Builder metaBuilder = LocalFileMetaOutter.LocalFileMeta.newBuilder();
            metaBuilder.setChecksum(Long.toHexString(checksum.getValue()));
            metaBuilder.setUserMeta(ByteString.copyFromUtf8((String)diskTableKey));
            if (writer.addFile(snapshotDirTar, (Message)metaBuilder.build())) continue;
            throw new RaftException("Failed to add snapshot file: '%s'", snapshotDirTar);
        }
    }

    private String decompressSnapshot(SnapshotReader reader, String snapshotDirTar) throws IOException {
        LocalFileMetaOutter.LocalFileMeta meta = (LocalFileMetaOutter.LocalFileMeta)reader.getFileMeta(snapshotDirTar);
        if (meta == null) {
            throw new IOException("Can't find snapshot archive file, path=" + snapshotDirTar);
        }
        String diskTableKey = meta.getUserMeta().toStringUtf8();
        E.checkArgument((boolean)this.dataDisks.containsKey(diskTableKey), (String)"The data path for '%s' should be exist", (Object[])new Object[]{diskTableKey});
        String dataPath = this.dataDisks.get(diskTableKey);
        String parentPath = Paths.get(dataPath, new String[0]).toAbsolutePath().getParent().toString();
        String snapshotDir = Paths.get(parentPath, StringUtils.removeEnd((String)snapshotDirTar, (String)TAR)).toString();
        FileUtils.deleteDirectory((File)new File(snapshotDir));
        LOG.info("Delete stale snapshot dir {}", (Object)snapshotDir);
        CRC64 checksum = new CRC64();
        String archiveFile = Paths.get(reader.getPath(), snapshotDirTar).toString();
        try {
            LOG.info("Prepare to decompress snapshot zip '{}' to '{}'", (Object)archiveFile, (Object)parentPath);
            long begin = System.currentTimeMillis();
            CompressStrategyManager.getDefault().decompressZip(archiveFile, parentPath, (Checksum)checksum);
            long end = System.currentTimeMillis();
            LOG.info("Decompress snapshot zip '{}' to '{}', took {} seconds", new Object[]{archiveFile, parentPath, Float.valueOf((float)(end - begin) / 1000.0f)});
        }
        catch (Throwable e) {
            throw new RaftException("Failed to decompress snapshot, zip=%s", e, archiveFile);
        }
        if (meta.hasChecksum()) {
            String expected = meta.getChecksum();
            String actual = Long.toHexString(checksum.getValue());
            E.checkArgument((boolean)expected.equals(actual), (String)"Snapshot checksum error: '%s' != '%s'", (Object[])new Object[]{actual, expected});
        }
        return snapshotDir;
    }

    private void deleteSnapshotDirs(Set<String> snapshotDirs) {
        for (String snapshotDir : snapshotDirs) {
            FileUtils.deleteQuietly((File)new File(snapshotDir));
        }
    }
}

