/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.raft;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.RaftGroupService;
import com.alipay.sofa.jraft.StateMachine;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.closure.ReadIndexClosure;
import com.alipay.sofa.jraft.core.Replicator;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.entity.Task;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.util.BytesUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.raft.RaftClosure;
import org.apache.hugegraph.backend.store.raft.RaftContext;
import org.apache.hugegraph.backend.store.raft.RaftException;
import org.apache.hugegraph.backend.store.raft.RaftStoreClosure;
import org.apache.hugegraph.backend.store.raft.StoreCommand;
import org.apache.hugegraph.backend.store.raft.StoreStateMachine;
import org.apache.hugegraph.util.LZ4Util;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class RaftNode {
    private static final Logger LOG = Log.logger(RaftNode.class);
    private final RaftContext context;
    private RaftGroupService raftGroupService;
    private final Node node;
    private final StoreStateMachine stateMachine;
    private final AtomicReference<LeaderInfo> leaderInfo;
    private final AtomicBoolean started;
    private final AtomicInteger busyCounter;

    public RaftNode(RaftContext context) {
        this.context = context;
        this.stateMachine = new StoreStateMachine(context);
        try {
            this.node = this.initRaftNode();
            LOG.info("Start raft node: {}", (Object)this);
        }
        catch (IOException e) {
            throw new BackendException("Failed to init raft node", e);
        }
        this.node.addReplicatorStateListener((Replicator.ReplicatorStateListener)new RaftStateListener());
        this.leaderInfo = new AtomicReference<LeaderInfo>(LeaderInfo.NO_LEADER);
        this.started = new AtomicBoolean(false);
        this.busyCounter = new AtomicInteger();
    }

    protected RaftContext context() {
        return this.context;
    }

    protected Node node() {
        assert (this.node != null);
        return this.node;
    }

    public PeerId nodeId() {
        return this.node.getNodeId().getPeerId();
    }

    public PeerId leaderId() {
        return this.leaderInfo.get().leaderId;
    }

    public boolean selfIsLeader() {
        return this.leaderInfo.get().selfIsLeader;
    }

    public void onLeaderInfoChange(PeerId leaderId, boolean selfIsLeader) {
        leaderId = leaderId != null ? leaderId.copy() : null;
        this.leaderInfo.set(new LeaderInfo(leaderId, selfIsLeader));
    }

    public void shutdown() {
        LOG.info("Shutdown raft node: {}", (Object)this);
        this.node.shutdown();
        if (this.raftGroupService != null) {
            this.raftGroupService.shutdown();
            try {
                this.raftGroupService.join();
            }
            catch (InterruptedException e) {
                throw new RaftException("Interrupted while shutdown raftGroupService");
            }
        }
    }

    public RaftClosure<?> snapshot() {
        RaftClosure future = new RaftClosure();
        try {
            this.node().snapshot(future);
            return future;
        }
        catch (Throwable e) {
            throw new BackendException("Failed to create snapshot", e);
        }
    }

    public void readIndex(byte[] reqCtx, ReadIndexClosure done) {
        this.node.readIndex(reqCtx, done);
    }

    public <T> T submitAndWait(StoreCommand command, RaftStoreClosure future) {
        this.submitCommand(command, future);
        try {
            Object result = future.waitFinished();
            return result;
        }
        catch (Throwable e) {
            throw new BackendException("Failed to wait store command %s", e, command);
        }
    }

    private void submitCommand(StoreCommand command, RaftStoreClosure future) {
        LeaderInfo leaderInfo = this.waitLeaderElected(600000);
        if (!leaderInfo.selfIsLeader) {
            this.context.rpcForwarder().forwardToLeader(leaderInfo.leaderId, command, future);
            return;
        }
        this.waitIfBusy();
        Task task = new Task();
        ByteBuffer buffer = LZ4Util.compress(command.data(), 8192).forReadWritten().asByteBuffer();
        LOG.debug("Submit to raft node '{}', the compressed bytes of command {} is {}", new Object[]{this.node, command.action(), buffer.limit()});
        task.setData(buffer);
        task.setDone((Closure)future);
        this.node.apply(task);
    }

    protected LeaderInfo waitLeaderElected(int timeout) {
        String group = this.context.group();
        LeaderInfo leaderInfo = this.leaderInfo.get();
        if (leaderInfo.leaderId != null) {
            return leaderInfo;
        }
        LOG.info("Waiting for raft group '{}' leader elected", (Object)group);
        long beginTime = System.currentTimeMillis();
        while (leaderInfo.leaderId == null) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new BackendException("Interrupted while waiting for raft group '%s' election", group, e);
            }
            long consumedTime = System.currentTimeMillis() - beginTime;
            if (timeout > 0 && consumedTime >= (long)timeout) {
                throw new BackendException("Waiting for raft group '%s' election timeout(%sms)", group, consumedTime);
            }
            leaderInfo = this.leaderInfo.get();
            assert (leaderInfo != null);
        }
        LOG.info("Waited for raft group '{}' leader elected successfully", (Object)group);
        return leaderInfo;
    }

    protected void waitRaftLogSynced(int timeout) {
        String group = this.context.group();
        LOG.info("Waiting for raft group '{}' log synced", (Object)group);
        long beginTime = System.currentTimeMillis();
        while (!this.started.get()) {
            this.node.readIndex(BytesUtil.EMPTY_BYTES, new ReadIndexClosure(){

                public void run(Status status, long index, byte[] reqCtx) {
                    RaftNode.this.started.set(status.isOk());
                }
            });
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new BackendException("Interrupted while waiting for raft group '%s' log synced", group, e);
            }
            long consumedTime = System.currentTimeMillis() - beginTime;
            if (timeout <= 0 || consumedTime < (long)timeout) continue;
            throw new BackendException("Waiting for raft group '%s' log synced timeout(%sms)", group, consumedTime);
        }
        LOG.info("Waited for raft group '{}' log synced successfully", (Object)group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIfBusy() {
        int counter = this.busyCounter.get();
        if (counter <= 0) {
            return;
        }
        int delta = 2000;
        Random random = new Random();
        int timeout = random.nextInt(delta) + 3000;
        int time = counter * timeout;
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new BackendException("The raft backend store is busy", e);
        }
        finally {
            if (this.busyCounter.get() > 0) {
                RaftNode raftNode = this;
                synchronized (raftNode) {
                    if (this.busyCounter.get() > 0) {
                        counter = this.busyCounter.decrementAndGet();
                        LOG.info("Decrease busy counter: [{}]", (Object)counter);
                    }
                }
            }
        }
    }

    private Node initRaftNode() throws IOException {
        NodeOptions nodeOptions = this.context.nodeOptions();
        nodeOptions.setFsm((StateMachine)this.stateMachine);
        String groupId = this.context.group();
        PeerId endpoint = this.context.endpoint();
        RpcServer rpcServer = this.context.rpcServer();
        LOG.debug("Start raft node with endpoint '{}', initial conf [{}]", (Object)endpoint, (Object)nodeOptions.getInitialConf());
        this.raftGroupService = new RaftGroupService(groupId, endpoint, nodeOptions, rpcServer, true);
        return this.raftGroupService.start(false);
    }

    public String toString() {
        return String.format("[%s-%s]", this.context.group(), this.nodeId());
    }

    private static class LeaderInfo {
        private static final LeaderInfo NO_LEADER = new LeaderInfo(null, false);
        private final PeerId leaderId;
        private final boolean selfIsLeader;

        public LeaderInfo(PeerId leaderId, boolean selfIsLeader) {
            this.leaderId = leaderId;
            this.selfIsLeader = selfIsLeader;
        }
    }

    protected final class RaftStateListener
    implements Replicator.ReplicatorStateListener {
        private volatile long lastPrintTime = 0L;

        public void onCreated(PeerId peer) {
            LOG.info("The node {} replicator has created", (Object)peer);
        }

        public void onDestroyed(PeerId peer) {
            LOG.warn("Replicator '{}' is ready to go offline", (Object)peer);
        }

        public void onError(PeerId peer, Status status) {
            long now = System.currentTimeMillis();
            long interval = now - this.lastPrintTime;
            if (interval >= 60000L) {
                LOG.warn("Replicator meet error: {}", (Object)status);
                this.lastPrintTime = now;
            }
            if (this.isWriteBufferOverflow(status)) {
                int count = RaftNode.this.busyCounter.incrementAndGet();
                LOG.info("Increase busy counter due to overflow: [{}]", (Object)count);
            }
        }

        public void onBusy(PeerId peer, Status status) {
            int count = RaftNode.this.busyCounter.incrementAndGet();
            LOG.info("Increase busy counter: [{}]", (Object)count);
        }

        private boolean isWriteBufferOverflow(Status status) {
            String expectMsg = "maybe write overflow";
            return RaftError.EINTERNAL == status.getRaftError() && status.getErrorMsg() != null && status.getErrorMsg().contains(expectMsg);
        }

        private boolean isRpcTimeout(Status status) {
            String expectMsg = "Invoke timeout";
            return RaftError.EINTERNAL == status.getRaftError() && status.getErrorMsg() != null && status.getErrorMsg().contains(expectMsg);
        }
    }
}

