/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.raft;

import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.entity.PeerId;
import com.google.protobuf.Message;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.raft.RaftClosure;
import org.apache.hugegraph.backend.store.raft.RaftContext;
import org.apache.hugegraph.backend.store.raft.RaftGroupManager;
import org.apache.hugegraph.backend.store.raft.RaftNode;
import org.apache.hugegraph.backend.store.raft.rpc.RaftRequests;
import org.apache.hugegraph.backend.store.raft.rpc.RpcForwarder;
import org.apache.hugegraph.util.E;

public class RaftGroupManagerImpl
implements RaftGroupManager {
    private final String group;
    private final RaftNode raftNode;
    private final RpcForwarder rpcForwarder;

    public RaftGroupManagerImpl(RaftContext context) {
        this.group = context.group();
        this.raftNode = context.node();
        this.rpcForwarder = context.rpcForwarder();
    }

    @Override
    public String group() {
        return this.group;
    }

    @Override
    public List<String> listPeers() {
        if (this.raftNode.selfIsLeader()) {
            List peerIds = this.raftNode.node().listPeers();
            return peerIds.stream().map(PeerId::toString).collect(Collectors.toList());
        }
        RaftRequests.ListPeersRequest request = RaftRequests.ListPeersRequest.getDefaultInstance();
        try {
            RaftClosure future = this.forwardToLeader((Message)request);
            RaftRequests.ListPeersResponse response = (RaftRequests.ListPeersResponse)future.waitFinished();
            return response.getEndpointsList();
        }
        catch (Throwable e) {
            throw new BackendException("Failed to list peers", e);
        }
    }

    @Override
    public String getLeader() {
        PeerId leaderId = this.raftNode.leaderId();
        E.checkState((leaderId != null ? 1 : 0) != 0, (String)"There is no leader for raft group '%s'", (Object[])new Object[]{this.group});
        return leaderId.toString();
    }

    @Override
    public String transferLeaderTo(String endpoint) {
        PeerId peerId = PeerId.parsePeer((String)endpoint);
        Status status = this.raftNode.node().transferLeadershipTo(peerId);
        if (!status.isOk()) {
            throw new BackendException("Failed to transfer leader to '%s', raft error: %s", endpoint, status.getErrorMsg());
        }
        return peerId.toString();
    }

    @Override
    public String setLeader(String endpoint) {
        PeerId newLeaderId = PeerId.parsePeer((String)endpoint);
        Node node = this.raftNode.node();
        if (node.getLeaderId().equals((Object)newLeaderId)) {
            return newLeaderId.toString();
        }
        if (this.raftNode.selfIsLeader()) {
            this.transferLeaderTo(endpoint);
        } else {
            RaftRequests.SetLeaderRequest request = RaftRequests.SetLeaderRequest.newBuilder().setEndpoint(endpoint).build();
            try {
                RaftClosure future = this.forwardToLeader((Message)request);
                future.waitFinished();
            }
            catch (Throwable e) {
                throw new BackendException("Failed to set leader to '%s'", e, endpoint);
            }
        }
        return newLeaderId.toString();
    }

    @Override
    public String addPeer(String endpoint) {
        PeerId peerId = PeerId.parsePeer((String)endpoint);
        try {
            RaftClosure future = new RaftClosure();
            if (this.raftNode.selfIsLeader()) {
                this.raftNode.node().addPeer(peerId, future);
            } else {
                RaftRequests.AddPeerRequest request = RaftRequests.AddPeerRequest.newBuilder().setEndpoint(endpoint).build();
                future = this.forwardToLeader((Message)request);
            }
            future.waitFinished();
        }
        catch (Throwable e) {
            throw new BackendException("Failed to add peer '%s'", e, endpoint);
        }
        return peerId.toString();
    }

    @Override
    public String removePeer(String endpoint) {
        PeerId peerId = PeerId.parsePeer((String)endpoint);
        try {
            RaftClosure future = new RaftClosure();
            if (this.raftNode.selfIsLeader()) {
                this.raftNode.node().removePeer(peerId, future);
            } else {
                RaftRequests.RemovePeerRequest request = RaftRequests.RemovePeerRequest.newBuilder().setEndpoint(endpoint).build();
                future = this.forwardToLeader((Message)request);
            }
            future.waitFinished();
        }
        catch (Throwable e) {
            throw new BackendException("Failed to remove peer '%s'", e, endpoint);
        }
        return peerId.toString();
    }

    private <T extends Message> RaftClosure<T> forwardToLeader(Message request) {
        PeerId leaderId = this.raftNode.leaderId();
        return this.rpcForwarder.forwardToLeader(leaderId, request);
    }
}

