/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store;

import java.util.NoSuchElementException;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.exception.LimitExceedException;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.iterator.CIter;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class BackendEntryIterator
implements CIter<BackendEntry> {
    private static final Logger LOG = Log.logger(BackendEntryIterator.class);
    public static final long INLINE_BATCH_SIZE = 500L;
    protected final Query query;
    protected BackendEntry current;
    private long count;

    public BackendEntryIterator(Query query) {
        E.checkNotNull((Object)query, (String)"query");
        this.query = query;
        this.count = 0L;
        this.current = null;
    }

    public boolean hasNext() {
        if (this.reachLimit()) {
            return false;
        }
        if (this.current != null) {
            return true;
        }
        return this.fetch();
    }

    public BackendEntry next() {
        BackendEntry current;
        this.checkCapacity();
        if (this.reachLimit()) {
            throw new NoSuchElementException();
        }
        if (this.current == null) {
            this.fetch();
        }
        if ((current = this.current) == null) {
            throw new NoSuchElementException();
        }
        this.current = null;
        this.count += this.sizeOf(current);
        return current;
    }

    public Object metadata(String meta, Object ... args) {
        if ("page".equals(meta)) {
            return this.pageState();
        }
        throw new NotSupportException("Invalid meta '%s'", meta);
    }

    public static final void checkInterrupted() {
        if (Thread.interrupted()) {
            throw new BackendException("Interrupted, maybe it is timed out", new InterruptedException());
        }
    }

    protected final void checkCapacity() throws LimitExceedException {
        this.query.checkCapacity(this.count());
    }

    protected final boolean reachLimit() {
        return this.reachLimit(this.count);
    }

    protected final boolean reachLimit(long count) {
        try {
            BackendEntryIterator.checkInterrupted();
        }
        catch (Throwable e) {
            try {
                this.close();
            }
            catch (Throwable ex) {
                LOG.warn("Failed to close backend entry iterator for interrupted query", ex);
            }
            throw e;
        }
        return this.query.reachLimit(count);
    }

    protected final long count() {
        return this.count;
    }

    protected final long fetched() {
        long ccount = this.current == null ? 0L : this.sizeOf(this.current);
        return this.count + ccount;
    }

    protected final void skipPageOffset(String page) {
        PageState pageState = PageState.fromString(page);
        int pageOffset = pageState.offset();
        if (pageOffset > 0) {
            this.skipOffset(pageOffset);
        }
    }

    protected void skipOffset() {
        long offset = this.query.offset() - this.query.actualOffset();
        if (offset <= 0L) {
            return;
        }
        long skipped = this.skipOffset(offset);
        this.count += skipped;
        this.query.goOffset(skipped);
    }

    protected long skipOffset(long offset) {
        assert (offset >= 0L);
        long skipped = 0L;
        while (skipped < offset && this.fetch()) {
            assert (this.current != null);
            long size = this.sizeOf(this.current);
            if ((skipped += size) > offset) {
                long skip = size - (skipped - offset);
                assert ((skipped -= this.skip(this.current, skip)) == offset);
                continue;
            }
            this.current = null;
        }
        return skipped;
    }

    protected long sizeOf(BackendEntry entry) {
        return 1L;
    }

    protected long skip(BackendEntry entry, long skip) {
        assert (this.sizeOf(entry) == 1L);
        return this.sizeOf(entry);
    }

    protected abstract boolean fetch();

    protected abstract PageState pageState();

    public static final class EmptyIterator
    extends BackendEntryIterator {
        public EmptyIterator(Query query) {
            super(query);
        }

        @Override
        protected boolean fetch() {
            return false;
        }

        @Override
        protected PageState pageState() {
            return PageState.EMPTY;
        }

        public void close() throws Exception {
        }
    }
}

