/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store;

import com.alipay.remoting.rpc.RpcServer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.event.EventListener;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class AbstractBackendStoreProvider
implements BackendStoreProvider {
    private static final Logger LOG = Log.logger(AbstractBackendStoreProvider.class);
    private String graph = null;
    private final EventHub storeEventHub = new EventHub("store");
    protected Map<String, BackendStore> stores = null;

    protected final void notifyAndWaitEvent(String event) {
        Future future = this.storeEventHub.notify(event, new Object[]{this});
        try {
            future.get();
        }
        catch (Throwable e) {
            LOG.warn("Error when waiting for event execution: {}", (Object)event, (Object)e);
        }
    }

    protected final void checkOpened() {
        E.checkState((this.graph != null && this.stores != null ? 1 : 0) != 0, (String)"The BackendStoreProvider has not been opened", (Object[])new Object[0]);
    }

    protected abstract BackendStore newSchemaStore(HugeConfig var1, String var2);

    protected abstract BackendStore newGraphStore(HugeConfig var1, String var2);

    protected abstract BackendStore newSystemStore(HugeConfig var1, String var2);

    @Override
    public void listen(EventListener listener) {
        this.storeEventHub.listen("*", listener);
    }

    @Override
    public void unlisten(EventListener listener) {
        this.storeEventHub.unlisten("*", listener);
    }

    @Override
    public String storedVersion() {
        return this.loadSystemStore(null).storedVersion();
    }

    @Override
    public String graph() {
        this.checkOpened();
        return this.graph;
    }

    @Override
    public void open(String graph) {
        LOG.debug("Graph '{}' open StoreProvider", (Object)this.graph);
        E.checkArgument((graph != null ? 1 : 0) != 0, (String)"The graph name can't be null", (Object[])new Object[0]);
        E.checkArgument((!graph.isEmpty() ? 1 : 0) != 0, (String)"The graph name can't be empty", (Object[])new Object[0]);
        this.graph = graph;
        this.stores = new ConcurrentHashMap<String, BackendStore>();
        this.storeEventHub.notify("store.open", new Object[]{this});
    }

    @Override
    public void waitReady(RpcServer rpcServer) {
    }

    @Override
    public void close() throws BackendException {
        LOG.debug("Graph '{}' close StoreProvider", (Object)this.graph);
        this.checkOpened();
        this.storeEventHub.notify("store.close", new Object[]{this});
    }

    @Override
    public void init() {
        this.checkOpened();
        for (BackendStore store : this.stores.values()) {
            store.init();
        }
        this.notifyAndWaitEvent("store.init");
        LOG.debug("Graph '{}' store has been initialized", (Object)this.graph);
    }

    @Override
    public void clear() throws BackendException {
        this.checkOpened();
        for (BackendStore store : this.stores.values()) {
            store.clear(false);
        }
        for (BackendStore store : this.stores.values()) {
            store.clear(true);
        }
        this.notifyAndWaitEvent("store.clear");
        LOG.debug("Graph '{}' store has been cleared", (Object)this.graph);
    }

    @Override
    public void truncate() {
        this.checkOpened();
        for (BackendStore store : this.stores.values()) {
            store.truncate();
        }
        this.notifyAndWaitEvent("store.truncate");
        LOG.debug("Graph '{}' store has been truncated", (Object)this.graph);
    }

    @Override
    public boolean initialized() {
        this.checkOpened();
        for (BackendStore store : this.stores.values()) {
            if (store.initialized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void createSnapshot() {
        String snapshotPrefix = "snapshot";
        for (BackendStore store : this.stores.values()) {
            store.createSnapshot(snapshotPrefix);
        }
    }

    @Override
    public void resumeSnapshot() {
        String snapshotPrefix = "snapshot";
        for (BackendStore store : this.stores.values()) {
            store.resumeSnapshot(snapshotPrefix, true);
        }
    }

    @Override
    public BackendStore loadSchemaStore(HugeConfig config) {
        String name = "m";
        LOG.debug("The '{}' StoreProvider load SchemaStore '{}'", (Object)this.type(), (Object)name);
        this.checkOpened();
        if (!this.stores.containsKey(name)) {
            BackendStore s = this.newSchemaStore(config, name);
            this.stores.putIfAbsent(name, s);
        }
        BackendStore store = this.stores.get(name);
        E.checkNotNull((Object)store, (String)"store");
        return store;
    }

    @Override
    public BackendStore loadGraphStore(HugeConfig config) {
        String name = "g";
        LOG.debug("The '{}' StoreProvider load GraphStore '{}'", (Object)this.type(), (Object)name);
        this.checkOpened();
        if (!this.stores.containsKey(name)) {
            BackendStore s = this.newGraphStore(config, name);
            this.stores.putIfAbsent(name, s);
        }
        BackendStore store = this.stores.get(name);
        E.checkNotNull((Object)store, (String)"store");
        return store;
    }

    @Override
    public BackendStore loadSystemStore(HugeConfig config) {
        String name = "s";
        LOG.debug("The '{}' StoreProvider load SystemStore '{}'", (Object)this.type(), (Object)name);
        this.checkOpened();
        if (!this.stores.containsKey(name)) {
            BackendStore s = this.newSystemStore(config, name);
            this.stores.putIfAbsent(name, s);
        }
        BackendStore store = this.stores.get(name);
        E.checkNotNull((Object)store, (String)"store");
        return store;
    }

    @Override
    public EventHub storeEventHub() {
        return this.storeEventHub;
    }

    @Override
    public void onCloneConfig(HugeConfig config, String newGraph) {
        config.setProperty(CoreOptions.STORE.name(), (Object)newGraph);
    }

    @Override
    public void onDeleteConfig(HugeConfig config) {
    }
}

