/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.serializer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.StringEncoding;

public class TextBackendEntry
implements BackendEntry,
Cloneable {
    public static final String VALUE_SPLITOR = "\u0003";
    private final HugeType type;
    private final Id id;
    private Id subId;
    private NavigableMap<String, String> columns;

    public TextBackendEntry(HugeType type, Id id) {
        this.type = type;
        this.id = id;
        this.subId = null;
        this.resetColumns();
    }

    @Override
    public HugeType type() {
        return this.type;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Id originId() {
        return this.id;
    }

    @Override
    public Id subId() {
        return this.subId;
    }

    @Override
    public long ttl() {
        return 0L;
    }

    public void subId(Id subId) {
        this.subId = subId;
    }

    public Set<String> columnNames() {
        return this.columns.keySet();
    }

    public void column(HugeKeys column, String value) {
        this.columns.put(column.string(), value);
    }

    public void column(String column, String value) {
        this.columns.put(column, value);
    }

    public String column(HugeKeys column) {
        return (String)this.columns.get(column.string());
    }

    public String column(String column) {
        return (String)this.columns.get(column);
    }

    public BackendEntry.BackendColumn columns(String column) {
        String value = (String)this.columns.get(column);
        if (value == null) {
            return null;
        }
        return BackendEntry.BackendColumn.of(StringEncoding.encode(column), StringEncoding.encode(value));
    }

    public Collection<BackendEntry.BackendColumn> columnsWithPrefix(String prefix) {
        return this.columnsWithPrefix(prefix, true, prefix);
    }

    public Collection<BackendEntry.BackendColumn> columnsWithPrefix(String start, boolean inclusiveStart, String prefix) {
        ArrayList<BackendEntry.BackendColumn> list = new ArrayList<BackendEntry.BackendColumn>();
        NavigableMap<String, String> map = this.columns.tailMap(start, inclusiveStart);
        for (Map.Entry e : map.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            if (!key.startsWith(prefix)) continue;
            list.add(BackendEntry.BackendColumn.of(StringEncoding.encode(key), StringEncoding.encode(value)));
        }
        return list;
    }

    public Collection<BackendEntry.BackendColumn> columnsWithRange(String start, boolean inclusiveStart, String end, boolean inclusiveEnd) {
        ArrayList<BackendEntry.BackendColumn> list = new ArrayList<BackendEntry.BackendColumn>();
        NavigableMap<String, String> map = this.columns.subMap(start, inclusiveStart, end, inclusiveEnd);
        for (Map.Entry e : map.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            list.add(BackendEntry.BackendColumn.of(StringEncoding.encode(key), StringEncoding.encode(value)));
        }
        return list;
    }

    public boolean contains(String column) {
        return this.columns.containsKey(column);
    }

    public boolean contains(String column, String value) {
        String col = (String)this.columns.get(column);
        return col != null && col.equals(value);
    }

    public boolean containsPrefix(String column) {
        NavigableMap<String, String> map = this.columns.tailMap(column, true);
        for (String c : map.keySet()) {
            if (!c.startsWith(column)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(String value) {
        return this.columns.values().contains(value);
    }

    public void append(TextBackendEntry entry) {
        for (Map.Entry col : entry.columns.entrySet()) {
            String newValue = (String)col.getValue();
            String oldValue = this.column((String)col.getKey());
            if (((String)col.getKey()).startsWith(HugeType.PROPERTY.string())) {
                this.columns.put((String)col.getKey(), (String)col.getValue());
                continue;
            }
            if (!((String)col.getKey()).endsWith(HugeKeys.ELEMENT_IDS.string())) continue;
            if ("[]".equals(oldValue)) {
                this.column((String)col.getKey(), newValue);
                continue;
            }
            ArrayList values = new ArrayList();
            List oldValues = JsonUtil.fromJson(oldValue, List.class);
            List newValues = JsonUtil.fromJson(newValue, List.class);
            values.addAll(oldValues);
            values.addAll(newValues);
            this.column((String)col.getKey(), JsonUtil.toJson(values));
        }
    }

    public void eliminate(TextBackendEntry entry) {
        for (Map.Entry col : entry.columns.entrySet()) {
            String newValue = (String)col.getValue();
            String oldValue = this.column((String)col.getKey());
            if (((String)col.getKey()).startsWith(HugeType.PROPERTY.string()) || ((String)col.getKey()).startsWith(HugeType.EDGE_OUT.string()) || ((String)col.getKey()).startsWith(HugeType.EDGE_IN.string())) {
                this.columns.remove(col.getKey());
                continue;
            }
            if (!((String)col.getKey()).endsWith(HugeKeys.ELEMENT_IDS.string())) continue;
            List oldValues = JsonUtil.fromJson(oldValue, List.class);
            List newValues = JsonUtil.fromJson(newValue, List.class);
            ArrayList values = new ArrayList(oldValues);
            values.removeAll(newValues);
            this.column((String)col.getKey(), JsonUtil.toJson(values));
        }
    }

    public String toString() {
        return String.format("%s: %s", this.id, this.columns.toString());
    }

    @Override
    public int columnsSize() {
        return this.columns.size();
    }

    @Override
    public Collection<BackendEntry.BackendColumn> columns() {
        ArrayList<BackendEntry.BackendColumn> list = new ArrayList<BackendEntry.BackendColumn>(this.columns.size());
        for (Map.Entry column : this.columns.entrySet()) {
            BackendEntry.BackendColumn bytesColumn = new BackendEntry.BackendColumn();
            bytesColumn.name = StringEncoding.encode((String)column.getKey());
            bytesColumn.value = StringEncoding.encode((String)column.getValue());
            list.add(bytesColumn);
        }
        return list;
    }

    @Override
    public void columns(Collection<BackendEntry.BackendColumn> bytesColumns) {
        for (BackendEntry.BackendColumn column : bytesColumns) {
            this.columns.put(StringEncoding.decode(column.name), StringEncoding.decode(column.value));
        }
    }

    @Override
    public void columns(BackendEntry.BackendColumn bytesColumn) {
        this.columns.put(StringEncoding.decode(bytesColumn.name), StringEncoding.decode(bytesColumn.value));
    }

    @Override
    public void merge(BackendEntry other) {
        TextBackendEntry text = (TextBackendEntry)other;
        this.columns.putAll(text.columns);
    }

    @Override
    public boolean mergeable(BackendEntry other) {
        if (!(other instanceof TextBackendEntry)) {
            return false;
        }
        if (!this.id().equals(other.id())) {
            return false;
        }
        this.columns(other.columns());
        return true;
    }

    @Override
    public void clear() {
        this.columns.clear();
    }

    private void resetColumns() {
        this.columns = new ConcurrentSkipListMap<String, String>();
    }

    public TextBackendEntry copy() {
        try {
            TextBackendEntry clone = (TextBackendEntry)this.clone();
            clone.columns = new ConcurrentSkipListMap<String, String>((SortedMap<String, String>)this.columns);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new BackendException(e);
        }
    }

    public TextBackendEntry copyLast(int count) {
        TextBackendEntry clone;
        try {
            clone = (TextBackendEntry)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BackendException(e);
        }
        clone.resetColumns();
        Iterator it = this.columns.entrySet().iterator();
        int skip = this.columns.size() - count;
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (i >= skip) {
                clone.columns.put((String)entry.getKey(), (String)entry.getValue());
            }
            ++i;
        }
        return clone;
    }

    public TextBackendEntry copyHead(int count) {
        TextBackendEntry clone;
        try {
            clone = (TextBackendEntry)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BackendException(e);
        }
        clone.resetColumns();
        Iterator it = this.columns.entrySet().iterator();
        for (int i = 0; it.hasNext() && i < count; ++i) {
            Map.Entry entry = it.next();
            clone.columns.put((String)entry.getKey(), (String)entry.getValue());
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextBackendEntry)) {
            return false;
        }
        TextBackendEntry other = (TextBackendEntry)obj;
        if (this.id() != other.id() && !this.id().equals(other.id())) {
            return false;
        }
        if (this.columns().size() != other.columns().size()) {
            return false;
        }
        for (Map.Entry e : this.columns.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            String otherValue = (String)other.columns.get(key);
            if (otherValue == null) {
                return false;
            }
            if (value.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.id().hashCode() ^ this.columns().hashCode();
    }
}

