/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.serializer;

import java.util.function.BiFunction;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.BinaryBackendEntry;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendEntryIterator;
import org.apache.hugegraph.util.E;

public class BinaryEntryIterator<Elem>
extends BackendEntryIterator {
    protected final BackendEntry.BackendIterator<Elem> results;
    protected final BiFunction<BackendEntry, Elem, BackendEntry> merger;
    protected BackendEntry next;

    public BinaryEntryIterator(BackendEntry.BackendIterator<Elem> results, Query query, BiFunction<BackendEntry, Elem, BackendEntry> m) {
        super(query);
        E.checkNotNull(results, (String)"results");
        E.checkNotNull(m, (String)"merger");
        this.results = results;
        this.merger = m;
        this.next = null;
        if (query.paging()) {
            assert (query.offset() == 0L);
            assert (PageState.fromString(query.page()).offset() == 0);
            this.skipPageOffset(query.page());
        } else {
            this.skipOffset();
        }
    }

    public void close() throws Exception {
        this.results.close();
    }

    @Override
    protected final boolean fetch() {
        assert (this.current == null);
        if (this.next != null) {
            this.current = this.next;
            this.next = null;
        }
        while (this.results.hasNext()) {
            Object elem = this.results.next();
            BackendEntry merged = this.merger.apply(this.current, elem);
            E.checkState((merged != null ? 1 : 0) != 0, (String)"Error when merging entry", (Object[])new Object[0]);
            if (this.current == null) {
                this.current = merged;
            } else if (merged == this.current) {
                assert (this.current != null);
                if (this.sizeOf(this.current) >= 500L) {
                    break;
                }
            } else {
                assert (this.next == null);
                this.next = merged;
                break;
            }
            if (!this.reachLimit(this.fetched() - 1L)) continue;
            this.removeLastRecord();
            this.results.close();
            break;
        }
        return this.current != null;
    }

    @Override
    protected final long sizeOf(BackendEntry entry) {
        return BinaryEntryIterator.sizeOfEntry(entry);
    }

    @Override
    protected final long skip(BackendEntry entry, long skip) {
        BinaryBackendEntry e = (BinaryBackendEntry)entry;
        E.checkState(((long)e.columnsSize() > skip ? 1 : 0) != 0, (String)"Invalid entry to skip", (Object[])new Object[0]);
        for (long i = 0L; i < skip; ++i) {
            e.removeColumn(0);
        }
        return e.columnsSize();
    }

    @Override
    protected PageState pageState() {
        byte[] position = this.results.position();
        if (position == null) {
            position = PageState.EMPTY_BYTES;
        }
        return new PageState(position, 0, (int)this.count());
    }

    private void removeLastRecord() {
        int lastOne = this.current.columnsSize() - 1;
        ((BinaryBackendEntry)this.current).removeColumn(lastOne);
    }

    public static long sizeOfEntry(BackendEntry entry) {
        if (entry.type().isEdge() || entry.type().isIndex()) {
            return entry.columnsSize();
        }
        return 1L;
    }
}

