/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.id;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.serializer.BytesBuffer;

public final class IdUtil {
    public static String writeStoredString(Id id) {
        String idString;
        switch (id.type()) {
            case LONG: 
            case STRING: 
            case UUID: {
                idString = IdGenerator.asStoredString(id);
                break;
            }
            case EDGE: {
                idString = EdgeId.asStoredString(id);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid id type " + (Object)((Object)id.type())));
            }
        }
        return id.type().prefix() + idString;
    }

    public static Id readStoredString(String id) {
        Id.IdType type = Id.IdType.valueOfPrefix(id);
        String idContent = id.substring(1);
        switch (type) {
            case LONG: 
            case STRING: 
            case UUID: {
                return IdGenerator.ofStoredString(idContent, type);
            }
            case EDGE: {
                return EdgeId.parseStoredString(idContent);
            }
        }
        throw new IllegalArgumentException("Invalid id: " + id);
    }

    public static Object writeBinString(Id id) {
        int len = id.edge() ? 128 : id.length() + 1;
        BytesBuffer buffer = BytesBuffer.allocate(len).writeId(id);
        buffer.forReadWritten();
        return buffer.asByteBuffer();
    }

    public static Id readBinString(Object id) {
        BytesBuffer buffer = BytesBuffer.wrap((ByteBuffer)id);
        return buffer.readId();
    }

    public static String writeString(Id id) {
        String idString = id.asString();
        return id.type().prefix() + idString;
    }

    public static Id readString(String id) {
        Id.IdType type = Id.IdType.valueOfPrefix(id);
        String idContent = id.substring(1);
        switch (type) {
            case LONG: {
                return IdGenerator.of(Long.parseLong(idContent));
            }
            case STRING: 
            case UUID: {
                return IdGenerator.of(idContent, type == Id.IdType.UUID);
            }
            case EDGE: {
                return EdgeId.parse(idContent);
            }
        }
        throw new IllegalArgumentException("Invalid id: " + id);
    }

    public static String writeLong(Id id) {
        return String.valueOf(id.asLong());
    }

    public static Id readLong(String id) {
        return IdGenerator.of(Long.parseLong(id));
    }

    public static String escape(char splitor, char escape, String ... values) {
        int length = values.length + 4;
        for (String value : values) {
            length += value.length();
        }
        StringBuilder escaped = new StringBuilder(length);
        for (String value : values) {
            if (escaped.length() > 0) {
                escaped.append(splitor);
            }
            if (value.indexOf(splitor) == -1) {
                escaped.append(value);
                continue;
            }
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                char ch = value.charAt(i);
                if (ch == splitor) {
                    escaped.append(escape);
                }
                escaped.append(ch);
            }
        }
        return escaped.toString();
    }

    public static String[] unescape(String id, String splitor, String escape) {
        String[] parts = id.split("(?<!" + escape + ")" + splitor, -1);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = StringUtils.replace((String)parts[i], (String)(escape + splitor), (String)splitor);
        }
        return parts;
    }
}

