/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import jakarta.ws.rs.NotAuthorizedException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.hugegraph.config.AuthOptions;
import org.apache.hugegraph.config.HugeConfig;

public class TokenGenerator {
    private final SecretKey key;

    public TokenGenerator(HugeConfig config) {
        String secretKey = (String)config.get(AuthOptions.AUTH_TOKEN_SECRET);
        this.key = Keys.hmacShaKeyFor((byte[])secretKey.getBytes(StandardCharsets.UTF_8));
    }

    public String create(Map<String, ?> payload, long expire) {
        return Jwts.builder().setClaims(payload).setExpiration(new Date(System.currentTimeMillis() + expire)).signWith((Key)this.key, SignatureAlgorithm.HS256).compact();
    }

    public Claims verify(String token) {
        try {
            Jws claimsJws = Jwts.parserBuilder().setSigningKey((Key)this.key).build().parseClaimsJws(token);
            return (Claims)claimsJws.getBody();
        }
        catch (ExpiredJwtException e) {
            throw new NotAuthorizedException("The token is expired", (Object)e, new Object[0]);
        }
        catch (JwtException e) {
            throw new NotAuthorizedException("Invalid token", (Object)e, new Object[0]);
        }
    }
}

