/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.auth.AuthManager;
import org.apache.hugegraph.auth.HugeAuthenticator;
import org.apache.hugegraph.auth.RolePermission;
import org.apache.hugegraph.auth.UserWithRole;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;

public class ConfigAuthenticator
implements HugeAuthenticator {
    public static final String KEY_USERNAME = "username";
    public static final String KEY_PASSWORD = "password";
    private final Map<String, String> tokens = new HashMap<String, String>();

    @Override
    public void setup(HugeConfig config) {
        this.tokens.putAll(config.getMap(ServerOptions.AUTH_USER_TOKENS));
        assert (!this.tokens.containsKey("admin"));
        this.tokens.put("admin", (String)config.get(ServerOptions.AUTH_ADMIN_TOKEN));
    }

    @Override
    public UserWithRole authenticate(String username, String password, String token) {
        E.checkArgumentNotNull((Object)username, (String)"The username parameter can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)password, (String)"The password parameter can't be null", (Object[])new Object[0]);
        E.checkArgument((token == null ? 1 : 0) != 0, (String)"The token must be null", (Object[])new Object[0]);
        RolePermission role = password.equals(this.tokens.get(username)) ? (username.equals("admin") ? ROLE_ADMIN : RolePermission.all((String)username)) : ROLE_NONE;
        return new UserWithRole(IdGenerator.of((String)username), username, role);
    }

    @Override
    public AuthManager authManager() {
        throw new NotImplementedException("AuthManager is unsupported by ConfigAuthenticator");
    }

    @Override
    public HugeGraph graph() {
        throw new NotImplementedException("graph() is unsupported by ConfigAuthenticator");
    }

    @Override
    public void initAdminUser(String password) {
        String adminToken = this.tokens.get("admin");
        E.checkArgument((boolean)Objects.equals(adminToken, password), (String)"The password can't be changed for ConfigAuthenticator", (Object[])new Object[0]);
    }

    public Authenticator.SaslNegotiator newSaslNegotiator(InetAddress remoteAddress) {
        throw new NotImplementedException("SaslNegotiator is unsupported by ConfigAuthenticator");
    }
}

