/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Iterator;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.api.traversers.TraverserAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.EdgeExistenceTraverser;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/edgeexist")
@Singleton
@Tag(name="EdgeExistenceAPI")
public class EdgeExistenceAPI
extends TraverserAPI {
    private static final Logger LOG = Log.logger(EdgeExistenceAPI.class);
    private static final String DEFAULT_EMPTY = "";

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="get edges from 'source' to 'target' vertex")
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="source") String source, @QueryParam(value="target") String target, @QueryParam(value="label") String edgeLabel, @QueryParam(value="sort_values") @DefaultValue(value="") String sortValues, @QueryParam(value="limit") @DefaultValue(value="100") long limit) {
        LOG.debug("Graph [{}] get edgeExistence with source '{}', target '{}', edgeLabel '{}', sortValue '{}', limit '{}'", new Object[]{graph, source, target, edgeLabel, sortValues, limit});
        E.checkArgumentNotNull((Object)source, (String)"The source can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)target, (String)"The target can't be null", (Object[])new Object[0]);
        Id sourceId = VertexAPI.checkAndParseVertexId(source);
        Id targetId = VertexAPI.checkAndParseVertexId(target);
        HugeGraph hugegraph = EdgeExistenceAPI.graph(manager, graph);
        EdgeExistenceTraverser traverser = new EdgeExistenceTraverser(hugegraph);
        Iterator edges = traverser.queryEdgeExistence(sourceId, targetId, edgeLabel, sortValues, limit);
        return manager.serializer((Graph)hugegraph).writeEdges(edges, false);
    }
}

