/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.hbase;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.coprocessor.AggregationClient;
import org.apache.hadoop.hbase.client.coprocessor.LongColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendSessionPool;
import org.apache.hugegraph.backend.store.hbase.HbaseOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.StringEncoding;
import org.apache.hugegraph.util.VersionUtil;
import org.slf4j.Logger;

public class HbaseSessions
extends BackendSessionPool {
    private static final Logger LOG = Log.logger(HbaseSessions.class);
    private static final String COPROCESSOR_AGGR = "org.apache.hadoop.hbase.coprocessor.AggregateImplementation";
    private static final long SCANNER_CACHING = 1000L;
    private final String namespace;
    private Connection hbase;

    public HbaseSessions(HugeConfig config, String namespace, String store) {
        super(config, namespace + "/" + store);
        this.namespace = namespace;
    }

    protected Connection hbase() {
        E.checkState((this.hbase != null ? 1 : 0) != 0, (String)"HBase connection is not opened", (Object[])new Object[0]);
        return this.hbase;
    }

    private Table table(String table) throws IOException {
        E.checkState((this.hbase != null ? 1 : 0) != 0, (String)"HBase connection is not opened", (Object[])new Object[0]);
        TableName tableName = TableName.valueOf((String)this.namespace, (String)table);
        return this.hbase.getTable(tableName);
    }

    private AggregationClient aggregationClient() {
        Configuration hConfig = this.hbase.getConfiguration();
        hConfig = HBaseConfiguration.create((Configuration)hConfig);
        long timeout = (Long)this.config().get(HbaseOptions.AGGR_TIMEOUT);
        hConfig.setLong("hbase.rpc.timeout", timeout * 1000L);
        hConfig.setLong("hbase.client.scanner.caching", 1000L);
        return new AggregationClient(hConfig);
    }

    public synchronized void open() throws IOException {
        HugeConfig config = this.config();
        String hosts = (String)config.get(HbaseOptions.HBASE_HOSTS);
        int port = (Integer)config.get(HbaseOptions.HBASE_PORT);
        String znodeParent = (String)config.get(HbaseOptions.HBASE_ZNODE_PARENT);
        boolean isEnableKerberos = (Boolean)config.get(HbaseOptions.HBASE_KERBEROS_ENABLE);
        Configuration hConfig = HBaseConfiguration.create();
        hConfig.set("hbase.zookeeper.quorum", hosts);
        hConfig.set("hbase.zookeeper.property.clientPort", String.valueOf(port));
        hConfig.set("zookeeper.znode.parent", znodeParent);
        hConfig.setInt("zookeeper.recovery.retry", ((Integer)config.get(HbaseOptions.HBASE_ZK_RETRY)).intValue());
        hConfig.setInt("hbase.hconnection.threads.max", ((Integer)config.get(HbaseOptions.HBASE_THREADS_MAX)).intValue());
        String hbaseSite = (String)config.get(HbaseOptions.HBASE_HBASE_SITE);
        hConfig.addResource(new Path(hbaseSite));
        if (isEnableKerberos) {
            String krb5Conf = (String)config.get(HbaseOptions.HBASE_KRB5_CONF);
            System.setProperty("java.security.krb5.conf", krb5Conf);
            String principal = (String)config.get(HbaseOptions.HBASE_KERBEROS_PRINCIPAL);
            String keyTab = (String)config.get(HbaseOptions.HBASE_KERBEROS_KEYTAB);
            hConfig.set("hadoop.security.authentication", "kerberos");
            hConfig.set("hbase.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)hConfig);
            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keyTab);
        }
        this.hbase = ConnectionFactory.createConnection((Configuration)hConfig);
    }

    protected synchronized boolean opened() {
        return this.hbase != null && !this.hbase.isClosed();
    }

    public final Session session() {
        return (Session)super.getOrNewSession();
    }

    protected Session newSession() {
        return new Session();
    }

    protected synchronized void doClose() {
        if (this.hbase == null || this.hbase.isClosed()) {
            return;
        }
        try {
            this.hbase.close();
        }
        catch (IOException e) {
            throw new BackendException("Failed to close HBase connection", (Throwable)e);
        }
    }

    public boolean existsNamespace() throws IOException {
        try (Admin admin = this.hbase.getAdmin();){
            for (NamespaceDescriptor ns : admin.listNamespaceDescriptors()) {
                if (!this.namespace.equals(ns.getName())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void createNamespace() throws IOException {
        NamespaceDescriptor ns = NamespaceDescriptor.create((String)this.namespace).build();
        try (Admin admin = this.hbase.getAdmin();){
            admin.createNamespace(ns);
        }
    }

    public void dropNamespace() throws IOException {
        try (Admin admin = this.hbase.getAdmin();){
            admin.deleteNamespace(this.namespace);
        }
    }

    public boolean existsTable(String table) throws IOException {
        TableName tableName = TableName.valueOf((String)this.namespace, (String)table);
        try (Admin admin = this.hbase.getAdmin();){
            boolean bl = admin.tableExists(tableName);
            return bl;
        }
    }

    public void createTable(String table, List<byte[]> cfs) throws IOException {
        TableDescriptorBuilder tdb = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.namespace, (String)table));
        for (byte[] cf : cfs) {
            tdb.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])cf).build());
        }
        tdb.setCoprocessor(COPROCESSOR_AGGR);
        try (Admin admin = this.hbase.getAdmin();){
            admin.createTable(tdb.build());
        }
    }

    public void createPreSplitTable(String table, List<byte[]> cfs, short numOfPartitions) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.namespace, (String)table));
        for (byte[] cf : cfs) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])cf).build());
        }
        byte[][] splits = new byte[numOfPartitions - 1][2];
        for (short split = 1; split < numOfPartitions; split = (short)(split + 1)) {
            splits[split - 1] = org.apache.hadoop.hbase.util.Bytes.toBytes((short)split);
        }
        builder.setCoprocessor(COPROCESSOR_AGGR);
        try (Admin admin = this.hbase.getAdmin();){
            admin.createTable(builder.build(), splits);
        }
    }

    public void dropTable(String table) throws IOException {
        TableName tableName = TableName.valueOf((String)this.namespace, (String)table);
        try (Admin admin = this.hbase.getAdmin();){
            try {
                admin.disableTable(tableName);
            }
            catch (TableNotEnabledException tableNotEnabledException) {
                // empty catch block
            }
            admin.deleteTable(tableName);
        }
    }

    public void enableTable(String table) throws IOException {
        assert (this.existsTable(table));
        TableName tableName = TableName.valueOf((String)this.namespace, (String)table);
        try (Admin admin = this.hbase.getAdmin();){
            if (admin.isTableEnabled(tableName)) {
                return;
            }
            try {
                admin.enableTable(tableName);
            }
            catch (TableNotDisabledException tableNotDisabledException) {
                // empty catch block
            }
        }
    }

    public Future<Void> disableTableAsync(String table) throws IOException {
        assert (this.existsTable(table));
        TableName tableName = TableName.valueOf((String)this.namespace, (String)table);
        Throwable throwable = null;
        try (Admin admin = this.hbase.getAdmin();){
            Future future = admin.disableTableAsync(tableName);
            return future;
        }
        catch (TableNotEnabledException ignored) {
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            return listenableFuture;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public Future<Void> truncateTableAsync(String table) throws IOException {
        assert (this.existsTable(table));
        TableName tableName = TableName.valueOf((String)this.namespace, (String)table);
        try (Admin admin = this.hbase.getAdmin();){
            Future future = admin.truncateTableAsync(tableName, true);
            return future;
        }
    }

    public void compactTables(List<String> tableNames) throws IOException {
        try (Admin admin = this.hbase.getAdmin();){
            for (String table : tableNames) {
                admin.compact(TableName.valueOf((String)this.namespace, (String)table));
            }
        }
    }

    public long storeSize(String table) throws IOException {
        long total = 0L;
        try (Admin admin = this.hbase.getAdmin();){
            for (ServerName rs : admin.getRegionServers()) {
                TableName tableName = TableName.valueOf((String)this.namespace, (String)table);
                for (RegionMetrics m : admin.getRegionMetrics(rs, tableName)) {
                    Double storeFileSize = m.getStoreFileSize().get(Size.Unit.BYTE);
                    total += storeFileSize.longValue();
                    Double memStoreFileSize = m.getMemStoreSize().get(Size.Unit.BYTE);
                    total += memStoreFileSize.longValue();
                }
            }
        }
        return total;
    }

    protected static class RowIterator
    implements BackendEntry.BackendIterator<Result> {
        private final ResultScanner resultScanner;
        private final Iterator<Result> results;
        private byte[] position = null;

        public RowIterator(ResultScanner resultScanner) {
            this.resultScanner = resultScanner;
            this.results = resultScanner.iterator();
        }

        public RowIterator(Result ... results) {
            this.resultScanner = null;
            ArrayList<Result> rs = new ArrayList<Result>(results.length);
            for (Result result : results) {
                if (result.isEmpty()) continue;
                rs.add(result);
            }
            this.results = rs.iterator();
        }

        public boolean hasNext() {
            boolean has = this.results.hasNext();
            if (!has) {
                this.position = null;
                this.close();
            }
            return has;
        }

        public Result next() {
            this.position = null;
            Result next = this.results.next();
            this.position = next.getRow();
            return next;
        }

        public void close() {
            if (this.resultScanner != null) {
                this.resultScanner.close();
            }
        }

        public byte[] position() {
            return this.position;
        }
    }

    public class CountSession
    implements HbaseSession<Number>,
    AutoCloseable {
        private final Session origin;
        private final AggregationClient aggrClient;

        public CountSession(Session origin) {
            this.origin = origin;
            this.aggrClient = HbaseSessions.this.aggregationClient();
        }

        @Override
        public void put(String table, byte[] family, byte[] rowkey, Collection<BackendEntry.BackendColumn> columns) {
            throw new NotSupportException("AggrSession.put");
        }

        @Override
        public void put(String table, byte[] family, byte[] rowkey, byte[] qualifier, byte[] value) {
            throw new NotSupportException("AggrSession.put");
        }

        @Override
        public void remove(String table, byte[] family, byte[] rowkey, byte[] qualifier, boolean latestVersion) {
            throw new NotSupportException("AggrSession.remove");
        }

        @Override
        public void delete(String table, byte[] family, byte[] rowkey) {
            throw new NotSupportException("AggrSession.delete");
        }

        @Override
        public Number get(String table, byte[] family, byte[] rowkey, byte[] qualifier) {
            return this.count(this.origin.get(table, family, rowkey, qualifier));
        }

        @Override
        public Number get(String table, byte[] family, byte[] rowkey) {
            return this.count(this.origin.get(table, family, rowkey));
        }

        @Override
        public Number get(String table, byte[] family, Set<byte[]> rowkeys) {
            return this.count((RowIterator)this.origin.get(table, family, (Set)rowkeys));
        }

        private long count(RowIterator iter) {
            long count = 0L;
            while (iter.hasNext()) {
                if (iter.next().isEmpty()) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Number scan(String table, Scan scan) {
            LongColumnInterpreter ci = new LongColumnInterpreter();
            try {
                return this.aggrClient.rowCount(HbaseSessions.this.table(table), (ColumnInterpreter)ci, scan);
            }
            catch (Throwable e) {
                throw new BackendException(e);
            }
        }

        @Override
        public long increase(String table, byte[] family, byte[] rowkey, byte[] qualifier, long value) {
            throw new NotSupportException("AggrSession.increase");
        }

        @Override
        public void close() throws IOException {
            this.aggrClient.close();
        }
    }

    public class Session
    extends BackendSession.AbstractBackendSession
    implements HbaseSession<RowIterator> {
        private final Map<String, List<Row>> batch = new HashMap<String, List<Row>>();

        private void batch(String table, Row row) {
            List<Row> rows = this.batch.get(table);
            if (rows == null) {
                rows = new ArrayList<Row>();
                this.batch.put(table, rows);
            }
            rows.add(row);
        }

        private int batchSize() {
            int size = 0;
            for (List<Row> puts : this.batch.values()) {
                size += puts.size();
            }
            return size;
        }

        private void checkBatchResults(Object[] results, List<Row> rows) throws Throwable {
            assert (rows.size() == results.length);
            for (int i = 0; i < results.length; ++i) {
                Object result = results[i];
                if (result instanceof Throwable) {
                    throw (Throwable)result;
                }
                if (result != null && ((Result)result).isEmpty()) continue;
                throw new BackendException("Failed batch for row: %s", new Object[]{rows.get(i)});
            }
        }

        public Connection hbase() {
            return HbaseSessions.this.hbase();
        }

        public String namespace() {
            return HbaseSessions.this.namespace;
        }

        public void open() {
            this.opened = true;
        }

        public void close() {
            assert (this.closeable());
            this.opened = false;
        }

        public boolean closed() {
            return !this.opened || !HbaseSessions.this.opened();
        }

        public boolean hasChanges() {
            return this.batch.size() > 0;
        }

        public Integer commit() {
            int count = this.batchSize();
            if (count <= 0) {
                return 0;
            }
            for (Map.Entry<String, List<Row>> action : this.batch.entrySet()) {
                List<Row> rows = action.getValue();
                Object[] results = new Object[rows.size()];
                try {
                    Table table = HbaseSessions.this.table(action.getKey());
                    Throwable throwable = null;
                    try {
                        table.batch(rows, results);
                        this.checkBatchResults(results, rows);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (table == null) continue;
                        if (throwable != null) {
                            try {
                                table.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        table.close();
                    }
                }
                catch (InterruptedIOException e) {
                    throw new BackendException("Interrupted, maybe it is timed out", (Throwable)e);
                }
                catch (Throwable e) {
                    throw new BackendException("Failed to commit, there may be inconsistent states for HBase", e);
                }
            }
            this.batch.clear();
            return count;
        }

        public void rollback() {
            this.batch.clear();
        }

        @Override
        public void put(String table, byte[] family, byte[] rowkey, Collection<BackendEntry.BackendColumn> columns) {
            Put put = new Put(rowkey);
            for (BackendEntry.BackendColumn column : columns) {
                put.addColumn(family, column.name, column.value);
            }
            this.batch(table, (Row)put);
        }

        public void put(String table, byte[] family, byte[] rowkey, Collection<BackendEntry.BackendColumn> columns, long ttl) {
            Put put = new Put(rowkey);
            for (BackendEntry.BackendColumn column : columns) {
                put.addColumn(family, column.name, column.value);
            }
            put.setTTL(ttl);
            this.batch(table, (Row)put);
        }

        @Override
        public void put(String table, byte[] family, byte[] rowkey, byte[] qualifier, byte[] value) {
            Put put = new Put(rowkey);
            put.addColumn(family, qualifier, value);
            this.batch(table, (Row)put);
        }

        public void put(String table, byte[] family, byte[] rowkey, byte[] qualifier, byte[] value, long ttl) {
            Put put = new Put(rowkey);
            put.addColumn(family, qualifier, value);
            put.setTTL(ttl);
            this.batch(table, (Row)put);
        }

        @Override
        public void remove(String table, byte[] family, byte[] rowkey, byte[] qualifier) {
            this.remove(table, family, rowkey, qualifier, false);
        }

        @Override
        public void remove(String table, byte[] family, byte[] rowkey, byte[] qualifier, boolean latestVersion) {
            assert (family != null);
            assert (rowkey != null);
            E.checkArgument((qualifier != null ? 1 : 0) != 0, (String)"HBase qualifier can't be null when removing", (Object[])new Object[0]);
            Delete delete = new Delete(rowkey);
            if (latestVersion) {
                delete.addColumn(family, qualifier);
            } else {
                delete.addColumns(family, qualifier);
            }
            this.batch(table, (Row)delete);
        }

        @Override
        public void delete(String table, byte[] family, byte[] rowkey) {
            assert (rowkey != null);
            Delete delete = new Delete(rowkey);
            if (family != null) {
                delete.addFamily(family);
            }
            this.batch(table, (Row)delete);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RowIterator get(String table, byte[] family, byte[] rowkey, byte[] qualifier) {
            assert (!this.hasChanges());
            Get get = new Get(rowkey);
            get.addColumn(family, qualifier);
            try (Table htable = HbaseSessions.this.table(table);){
                RowIterator rowIterator = new RowIterator(htable.get(get));
                return rowIterator;
            }
            catch (IOException e) {
                throw new BackendException((Throwable)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RowIterator get(String table, byte[] family, byte[] rowkey) {
            assert (!this.hasChanges());
            Get get = new Get(rowkey);
            if (family != null) {
                get.addFamily(family);
            }
            try (Table htable = HbaseSessions.this.table(table);){
                RowIterator rowIterator = new RowIterator(htable.get(get));
                return rowIterator;
            }
            catch (IOException e) {
                throw new BackendException((Throwable)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RowIterator get(String table, byte[] family, Set<byte[]> rowkeys) {
            assert (!this.hasChanges());
            ArrayList<Get> gets = new ArrayList<Get>(rowkeys.size());
            for (byte[] rowkey : rowkeys) {
                Get get = new Get(rowkey);
                if (family != null) {
                    get.addFamily(family);
                }
                gets.add(get);
            }
            try (Table htable = HbaseSessions.this.table(table);){
                RowIterator rowIterator = new RowIterator(htable.get(gets));
                return rowIterator;
            }
            catch (IOException e) {
                throw new BackendException((Throwable)e);
            }
        }

        @Override
        public RowIterator scan(String table, byte[] startRow, boolean inclusiveStart, byte[] stopRow, boolean inclusiveStop) {
            assert (!this.hasChanges());
            Scan scan = new Scan();
            if (startRow != null) {
                scan.withStartRow(startRow, inclusiveStart);
            }
            if (stopRow != null) {
                String version = VersionInfo.getVersion();
                if (inclusiveStop && !VersionUtil.gte((String)version, (String)"2.0")) {
                    inclusiveStop = false;
                    stopRow = Arrays.copyOf(stopRow, stopRow.length + 1);
                }
                if (Bytes.equals((byte[])startRow, (byte[])stopRow) && inclusiveStart && !inclusiveStop) {
                    return new RowIterator(new Result[0]);
                }
                scan.withStopRow(stopRow, inclusiveStop);
            }
            return this.scan(table, scan);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RowIterator scan(String table, Scan scan) {
            assert (!this.hasChanges());
            try (Table htable = HbaseSessions.this.table(table);){
                RowIterator rowIterator = new RowIterator(htable.getScanner(scan));
                return rowIterator;
            }
            catch (IOException e) {
                throw new BackendException((Throwable)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long increase(String table, byte[] family, byte[] rowkey, byte[] qualifier, long value) {
            try (Table htable = HbaseSessions.this.table(table);){
                long l = htable.incrementColumnValue(rowkey, family, qualifier, value);
                return l;
            }
            catch (IOException e) {
                throw new BackendException((Throwable)e);
            }
        }

        public long storeSize(String table) throws IOException {
            return HbaseSessions.this.storeSize(table);
        }

        private void dump(String table, Scan scan) throws IOException {
            LOG.info(String.format(">>>> scan table {} with {}", table, scan));
            RowIterator iterator = this.scan(table, scan);
            while (iterator.hasNext()) {
                Result row = iterator.next();
                LOG.info(StringEncoding.format((byte[])row.getRow()));
                CellScanner cellScanner = row.cellScanner();
                while (cellScanner.advance()) {
                    Cell cell = cellScanner.current();
                    byte[] key = CellUtil.cloneQualifier((Cell)cell);
                    byte[] val = CellUtil.cloneValue((Cell)cell);
                    LOG.info("  {}={}", (Object)StringEncoding.format((byte[])key), (Object)StringEncoding.format((byte[])val));
                }
            }
        }

        public CountSession countSession() {
            return new CountSession(this);
        }
    }

    public static interface HbaseSession<R> {
        public void put(String var1, byte[] var2, byte[] var3, Collection<BackendEntry.BackendColumn> var4);

        public void put(String var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

        default public void remove(String table, byte[] family, byte[] rowkey, byte[] qualifier) {
            this.remove(table, family, rowkey, qualifier, false);
        }

        public void remove(String var1, byte[] var2, byte[] var3, byte[] var4, boolean var5);

        public void delete(String var1, byte[] var2, byte[] var3);

        public R get(String var1, byte[] var2, byte[] var3, byte[] var4);

        public R get(String var1, byte[] var2, byte[] var3);

        public R get(String var1, byte[] var2, Set<byte[]> var3);

        default public R scan(String table, long limit) {
            Scan scan = new Scan();
            if (limit >= 0L) {
                scan.setFilter((Filter)new PageFilter(limit));
            }
            return this.scan(table, scan);
        }

        default public R scan(String table, byte[] prefix) {
            return this.scan(table, prefix, true, prefix);
        }

        default public R scan(String table, Set<byte[]> prefixes) {
            FilterList orFilters = new FilterList(FilterList.Operator.MUST_PASS_ONE);
            for (byte[] prefix : prefixes) {
                FilterList andFilters = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
                ranges.add(new MultiRowRangeFilter.RowRange(prefix, true, null, true));
                andFilters.addFilter((Filter)new MultiRowRangeFilter(ranges));
                andFilters.addFilter((Filter)new PrefixFilter(prefix));
                orFilters.addFilter((Filter)andFilters);
            }
            Scan scan = new Scan().setFilter((Filter)orFilters);
            return this.scan(table, scan);
        }

        default public R scan(String table, byte[] startRow, boolean inclusiveStart, byte[] prefix) {
            Scan scan = new Scan();
            if (startRow == prefix) {
                scan.setRowPrefixFilter(prefix);
            } else {
                scan.withStartRow(startRow, inclusiveStart).setFilter((Filter)new PrefixFilter(prefix));
            }
            return this.scan(table, scan);
        }

        default public R scan(String table, byte[] startRow, byte[] stopRow) {
            return this.scan(table, startRow, true, stopRow, false);
        }

        default public R scan(String table, byte[] startRow, boolean inclusiveStart, byte[] stopRow, boolean inclusiveStop) {
            Scan scan = new Scan().withStartRow(startRow, inclusiveStart);
            if (stopRow != null) {
                scan.withStopRow(stopRow, inclusiveStop);
            }
            return this.scan(table, scan);
        }

        public R scan(String var1, Scan var2);

        public long increase(String var1, byte[] var2, byte[] var3, byte[] var4, long var5);
    }
}

