/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.gridkit.jvmtool.GcCpuUsageMonitor;
import org.gridkit.jvmtool.NativeThreadMonitor;
import org.gridkit.jvmtool.SafePointMonitor;
import org.gridkit.jvmtool.stacktrace.ThreadMXBeanEx;
import org.gridkit.util.formating.Formats;

public class MBeanCpuUsageReporter {
    private static final ObjectName THREADING_MBEAN = MBeanCpuUsageReporter.name("java.lang:type=Threading");
    private MBeanServerConnection mserver;
    private ThreadMXBean mbean;
    private long lastTimestamp;
    private long lastProcessCpuTime;
    private long lastProcessOSCpuTime;
    private long lastProcessOSSysTime;
    private long lastYougGcTime;
    private long lastOldGcTime;
    private long lastSafePointCount;
    private long lastSafePointTime;
    private long lastSafePointSyncTime;
    private BigInteger lastCummulativeCpuTime = BigInteger.valueOf(0L);
    private BigInteger lastCummulativeUserTime = BigInteger.valueOf(0L);
    private BigInteger lastCummulativeAllocatedAmount = BigInteger.valueOf(0L);
    private Map<Long, ThreadTrac> threadDump = new HashMap<Long, ThreadTrac>();
    private Map<Long, ThreadNote> notes = new HashMap<Long, ThreadNote>();
    private List<Comparator<ThreadLine>> comparators = new ArrayList<Comparator<ThreadLine>>();
    private int topLimit = Integer.MAX_VALUE;
    private Pattern filter;
    private boolean bulkCpuEnabled;
    private boolean threadAllocatedMemoryEnabled;
    private boolean contentionMonitoringEnabled = false;
    private GcCpuUsageMonitor gcMon;
    private SafePointMonitor spMon;
    private NativeThreadMonitor ntMon;

    private static ObjectName name(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public MBeanCpuUsageReporter(MBeanServerConnection mserver) {
        this.mserver = mserver;
        this.mbean = ThreadMXBeanEx.BeanHelper.connectThreadMXBean((MBeanServerConnection)mserver);
        this.threadAllocatedMemoryEnabled = this.getThreadingMBeanCapability("ThreadAllocatedMemoryEnabled");
        this.bulkCpuEnabled = this.verifyBulkCpu();
        this.lastTimestamp = System.nanoTime();
        this.lastProcessCpuTime = this.getProcessCpuTime();
    }

    public void setGcCpuUsageMonitor(GcCpuUsageMonitor gcMon) {
        this.gcMon = gcMon;
    }

    public void setSafePointMonitor(SafePointMonitor spMon) {
        this.spMon = spMon;
    }

    public void setNativeThreadMonitor(NativeThreadMonitor ntMon) {
        this.ntMon = ntMon;
    }

    public void setContentionMonitoringEnabled(boolean enabled) {
        if (enabled) {
            try {
                Attribute attr = new Attribute("ThreadContentionMonitoringEnabled", Boolean.TRUE);
                this.mserver.setAttribute(THREADING_MBEAN, attr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.contentionMonitoringEnabled = enabled;
    }

    private boolean getThreadingMBeanCapability(String attrName) {
        try {
            Object val = this.mserver.getAttribute(THREADING_MBEAN, attrName);
            return Boolean.TRUE.equals(val);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean verifyBulkCpu() {
        try {
            long[] ids = this.mbean.getAllThreadIds();
            ((ThreadMXBeanEx)this.mbean).getThreadCpuTime(ids);
            ((ThreadMXBeanEx)this.mbean).getThreadUserTime(ids);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void sortByThreadName() {
        this.comparators.add(0, new ThreadNameComparator());
    }

    public void sortByUserCpu() {
        this.comparators.add(0, new UserTimeComparator());
    }

    public void sortBySysCpu() {
        this.comparators.add(0, new SysTimeComparator());
    }

    public void sortByTotalCpu() {
        this.comparators.add(0, new CpuTimeComparator());
    }

    public void sortByAllocRate() {
        this.comparators.add(0, new AllocRateComparator());
    }

    public void setTopLimit(int n) {
        this.topLimit = n;
    }

    public void setThreadFilter(Pattern regEx) {
        this.filter = regEx;
    }

    public void probe() {
        try {
            long[] ids = this.mbean.getAllThreadIds();
            ThreadInfo[] ti = this.mbean.getThreadInfo(ids);
            HashMap<Long, ThreadInfo> buf = new HashMap<Long, ThreadInfo>();
            for (ThreadInfo t : ti) {
                if (t == null) continue;
                buf.put(t.getThreadId(), t);
            }
            for (Long key : this.threadDump.keySet()) {
                ThreadInfo t;
                ThreadTrac tt = this.threadDump.get(key);
                t = (ThreadInfo)buf.remove(key);
                if (t != null) {
                    tt.name = t.getThreadName();
                    tt.lastThreadInfo = t;
                    continue;
                }
                tt.dead = true;
            }
            for (ThreadInfo t : buf.values()) {
                ThreadTrac tt = new ThreadTrac();
                tt.name = t.getThreadName();
                tt.lastThreadInfo = t;
                this.threadDump.put(t.getThreadId(), tt);
            }
            if (this.threadAllocatedMemoryEnabled) {
                long[] lArray = ((ThreadMXBeanEx)this.mbean).getThreadAllocatedBytes(ids);
                for (int i = 0; i != ids.length; ++i) {
                    if (this.threadDump.get(ids[i]) == null) continue;
                    this.threadDump.get(ids[i]).lastAllocatedBytes = lArray[i];
                }
            }
            if (this.bulkCpuEnabled) {
                long[] lArray = ((ThreadMXBeanEx)this.mbean).getThreadCpuTime(ids);
                long[] usr = ((ThreadMXBeanEx)this.mbean).getThreadUserTime(ids);
                for (int i = 0; i != ids.length; ++i) {
                    if (this.threadDump.get(ids[i]) == null) continue;
                    this.threadDump.get(ids[i]).lastCpuTime = lArray[i];
                    this.threadDump.get(ids[i]).lastUserTime = usr[i];
                }
            } else {
                for (long id : ids) {
                    if (this.threadDump.get(id) == null) continue;
                    ThreadTrac tt = this.threadDump.get(id);
                    tt.lastCpuTime = this.mbean.getThreadCpuTime(id);
                    tt.lastUserTime = this.mbean.getThreadCpuTime(id);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanDead() {
        Iterator<ThreadTrac> it = this.threadDump.values().iterator();
        while (it.hasNext()) {
            ThreadTrac tt = it.next();
            if (!tt.dead) continue;
            it.remove();
        }
    }

    public String report() {
        this.probe();
        StringBuilder sb = new StringBuilder();
        long currentTime = System.nanoTime();
        long timeSplit = currentTime - this.lastTimestamp;
        long currentCpuTime = this.getProcessCpuTime();
        long currentOsSysTime = this.ntMon == null ? 0L : this.ntMon.getProcessSysCPU();
        long currentOsCpuTime = this.ntMon == null ? 0L : this.ntMon.getProcessCPU();
        long currentYoungGcTime = this.gcMon == null ? 0L : this.gcMon.getYoungGcCpu();
        long currentOldGcTime = this.gcMon == null ? 0L : this.gcMon.getOldGcCpu();
        long currentSafePointCount = this.spMon == null ? 0L : this.spMon.getSafePointCount();
        long currentSafePointTime = this.spMon == null ? 0L : this.spMon.getSafePointTime();
        long currentSafePointSyncTime = this.spMon == null ? 0L : this.spMon.getSafePointSyncTime();
        HashMap<Long, ThreadNote> newNotes = new HashMap<Long, ThreadNote>();
        BigInteger deltaCpu = BigInteger.valueOf(0L);
        BigInteger deltaUser = BigInteger.valueOf(0L);
        BigInteger deltaAlloc = BigInteger.valueOf(0L);
        List<ThreadLine> table = new ArrayList();
        for (long tid : this.getAllThreadIds()) {
            String threadName = this.getThreadName(tid);
            ThreadNote lastNote = this.notes.get(tid);
            ThreadNote newNote = new ThreadNote();
            newNote.lastCpuTime = this.getThreadCpuTime(tid);
            newNote.lastUserTime = this.getThreadUserTime(tid);
            newNote.lastAllocatedBytes = this.getThreadAllocatedBytes(tid);
            newNote.lastWaitCount = this.getThreadWaitCount(tid);
            newNote.lastWaitTime = this.getThreadWaitTime(tid);
            newNote.lastBlockCount = this.getThreadBlockCount(tid);
            newNote.lastBlockTime = this.getThreadBlockTime(tid);
            newNotes.put(tid, newNote);
            long lastCpu = lastNote == null ? 0L : lastNote.lastCpuTime;
            long lastUser = lastNote == null ? 0L : lastNote.lastUserTime;
            long lastAlloc = lastNote == null ? 0L : lastNote.lastAllocatedBytes;
            deltaCpu = deltaCpu.add(BigInteger.valueOf(newNote.lastCpuTime - lastCpu));
            deltaUser = deltaUser.add(BigInteger.valueOf(newNote.lastUserTime - lastUser));
            deltaAlloc = deltaAlloc.add(BigInteger.valueOf(newNote.lastAllocatedBytes - lastAlloc));
            if (lastNote == null || this.filter != null && !this.filter.matcher(threadName).matches()) continue;
            double cpuT = (double)(newNote.lastCpuTime - lastNote.lastCpuTime) / (double)timeSplit;
            double userT = (double)(newNote.lastUserTime - lastNote.lastUserTime) / (double)timeSplit;
            double allocRate = (double)(newNote.lastAllocatedBytes - lastNote.lastAllocatedBytes) * (double)TimeUnit.SECONDS.toNanos(1L) / (double)timeSplit;
            double waitRate = (double)(newNote.lastWaitCount - lastNote.lastWaitCount) * (double)TimeUnit.SECONDS.toNanos(1L) / (double)timeSplit;
            double waitT = newNote.lastWaitTime < 0L ? Double.NaN : (double)(newNote.lastWaitTime - lastNote.lastWaitTime) / (double)timeSplit;
            double blockRate = (double)(newNote.lastBlockCount - lastNote.lastBlockCount) * (double)TimeUnit.SECONDS.toNanos(1L) / (double)timeSplit;
            double blockT = newNote.lastBlockTime < 0L ? Double.NaN : (double)(newNote.lastBlockTime - lastNote.lastBlockTime) / (double)timeSplit;
            ThreadLine line = new ThreadLine(tid, this.getThreadName(tid));
            line.userT = 100.0 * userT;
            line.sysT = 100.0 * (cpuT - userT);
            line.allocRate = allocRate;
            line.waitRate = waitRate;
            line.waitT = 100.0 * waitT;
            line.blockRate = blockRate;
            line.blockT = 100.0 * blockT;
            table.add(line);
        }
        int threadCount = table.size();
        if (table.size() > 0) {
            int osthreadcount;
            for (Comparator<ThreadLine> cmp : this.comparators) {
                Collections.sort(table, cmp);
            }
            if (table.size() > this.topLimit) {
                table = table.subList(0, this.topLimit);
            }
            double processT = (double)(currentCpuTime - this.lastProcessCpuTime) / (double)timeSplit;
            double cpuT = (double)deltaCpu.longValue() / (double)timeSplit;
            double userT = (double)deltaUser.longValue() / (double)timeSplit;
            double allocRate = (double)deltaAlloc.longValue() * (double)TimeUnit.SECONDS.toNanos(1L) / (double)timeSplit;
            double youngGcT = ((double)currentYoungGcTime - (double)this.lastYougGcTime) / (double)timeSplit;
            double oldGcT = ((double)currentOldGcTime - (double)this.lastOldGcTime) / (double)timeSplit;
            String osproccpu = "";
            if (currentOsCpuTime > 0L) {
                double processCpuT = (double)(currentOsCpuTime - this.lastProcessOSCpuTime) / (double)TimeUnit.NANOSECONDS.toMicros(timeSplit);
                double processSysT = (double)(currentOsSysTime - this.lastProcessOSSysTime) / (double)TimeUnit.NANOSECONDS.toMicros(timeSplit);
                osproccpu = String.format(" (OS usr+sys: %.2f%% sys: %.2f%%)", processCpuT, processSysT);
            }
            sb.append(Formats.toDatestamp(System.currentTimeMillis()));
            sb.append(String.format(" Process summary \n  process cpu=%.2f%%%s\n  application cpu=%.2f%% (user=%.2f%% sys=%.2f%%)\n  other: cpu=%.2f%% \n", 100.0 * processT, osproccpu, 100.0 * cpuT, 100.0 * userT, 100.0 * (cpuT - userT), 100.0 * (processT - cpuT), threadCount));
            int n = osthreadcount = this.ntMon == null ? 0 : this.ntMon.getThreadsForProcess().length;
            if (osthreadcount > threadCount) {
                sb.append(String.format("  thread count: %d (OS threads: %d)\n", threadCount, osthreadcount));
            } else {
                sb.append(String.format("  thread count: %d\n", threadCount));
            }
            if (currentYoungGcTime > 0L) {
                sb.append(String.format("  GC time=%.2f%% (young=%.2f%%, old=%.2f%%)\n", 100.0 * (youngGcT + oldGcT), 100.0 * youngGcT, 100.0 * oldGcT));
            }
            if (this.threadAllocatedMemoryEnabled) {
                sb.append(String.format("  heap allocation rate %sb/s\n", Formats.toMemorySize((long)allocRate)));
            }
            if (currentSafePointCount > 0L) {
                if (currentSafePointCount == this.lastSafePointCount) {
                    sb.append(String.format("  no safe points\n", new Object[0]));
                } else {
                    double spRate = (double)TimeUnit.SECONDS.toNanos(1L) * (double)(currentSafePointCount - this.lastSafePointCount) / (double)timeSplit;
                    double spCpuUsage = (double)(currentSafePointTime - this.lastSafePointTime) / (double)timeSplit;
                    double spSyncCpuUsage = (double)(currentSafePointSyncTime - this.lastSafePointSyncTime) / (double)timeSplit;
                    double spAvg = (double)(currentSafePointTime + currentSafePointSyncTime - this.lastSafePointTime - this.lastSafePointSyncTime) / (double)(currentSafePointCount - this.lastSafePointCount) / (double)TimeUnit.MILLISECONDS.toNanos(1L);
                    sb.append(String.format("  safe point rate: %.1f (events/s) avg. safe point pause: %.2fms\n", spRate, spAvg));
                    sb.append(String.format("  safe point sync time: %.2f%% processing time: %.2f%% (wallclock time)\n", 100.0 * spSyncCpuUsage, 100.0 * spCpuUsage));
                }
            }
            for (ThreadLine line : table) {
                sb.append(this.format(line)).append('\n');
            }
            sb.append("\n");
        }
        this.lastTimestamp = currentTime;
        this.notes = newNotes;
        this.lastCummulativeCpuTime = this.lastCummulativeCpuTime.add(deltaCpu);
        this.lastCummulativeUserTime = this.lastCummulativeUserTime.add(deltaUser);
        this.lastCummulativeAllocatedAmount = this.lastCummulativeAllocatedAmount.add(deltaAlloc);
        this.lastProcessCpuTime = currentCpuTime;
        this.lastProcessOSCpuTime = currentOsCpuTime;
        this.lastProcessOSSysTime = currentOsSysTime;
        this.lastYougGcTime = currentYoungGcTime;
        this.lastOldGcTime = currentOldGcTime;
        this.lastSafePointCount = currentSafePointCount;
        this.lastSafePointTime = currentSafePointTime;
        this.lastSafePointSyncTime = currentSafePointSyncTime;
        this.cleanDead();
        return sb.toString();
    }

    private Object format(ThreadLine line) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[%06d] user=%5.2f%% sys=%5.2f%% ", line.id, line.userT, line.sysT));
        if (this.contentionMonitoringEnabled) {
            if (Double.isNaN(line.waitT)) {
                sb.append(String.format("wait=%s/s ", Formats.formatRate(line.waitRate)));
            } else {
                sb.append(String.format("wait=%s/s(%5.2f%%) ", Formats.formatRate(line.waitRate), line.waitT));
            }
            if (Double.isNaN(line.blockT)) {
                sb.append(String.format("block=%s/s ", Formats.formatRate(line.blockRate)));
            } else {
                sb.append(String.format("block=%s/s(%5.2f%%) ", Formats.formatRate(line.blockRate), line.blockT));
            }
        }
        if (this.threadAllocatedMemoryEnabled) {
            sb.append(String.format("alloc=%6sb/s ", Formats.toMemorySize((long)line.allocRate)));
        }
        sb.append(String.format("- %s", line.name));
        return sb.toString();
    }

    private String getThreadName(long tid) {
        return this.threadDump.get(tid).name;
    }

    private Collection<Long> getAllThreadIds() {
        return new TreeSet<Long>(this.threadDump.keySet());
    }

    private long getThreadCpuTime(long tid) {
        return this.threadDump.get(tid).lastCpuTime;
    }

    private long getThreadUserTime(long tid) {
        return this.threadDump.get(tid).lastUserTime;
    }

    private long getThreadAllocatedBytes(long tid) {
        return this.threadDump.get(tid).lastAllocatedBytes;
    }

    private long getThreadWaitCount(long tid) {
        return this.threadDump.get(tid).lastThreadInfo.getWaitedCount();
    }

    private long getThreadWaitTime(long tid) {
        return this.threadDump.get(tid).lastThreadInfo.getWaitedTime() * 1000000L;
    }

    private long getThreadBlockCount(long tid) {
        return this.threadDump.get(tid).lastThreadInfo.getBlockedCount();
    }

    private long getThreadBlockTime(long tid) {
        return this.threadDump.get(tid).lastThreadInfo.getBlockedTime() * 1000000L;
    }

    private long getProcessCpuTime() {
        try {
            ObjectName bean = new ObjectName("java.lang:type=OperatingSystem");
            return (Long)this.mserver.getAttribute(bean, "ProcessCpuTime");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class AllocRateComparator
    implements Comparator<ThreadLine> {
        private AllocRateComparator() {
        }

        @Override
        public int compare(ThreadLine o1, ThreadLine o2) {
            return Double.compare(o2.allocRate, o1.allocRate);
        }
    }

    private static class ThreadNameComparator
    implements Comparator<ThreadLine> {
        private ThreadNameComparator() {
        }

        @Override
        public int compare(ThreadLine o1, ThreadLine o2) {
            return o1.name.compareTo(o2.name);
        }
    }

    private static class CpuTimeComparator
    implements Comparator<ThreadLine> {
        private CpuTimeComparator() {
        }

        @Override
        public int compare(ThreadLine o1, ThreadLine o2) {
            return Double.compare(o2.userT + o2.sysT, o1.userT + o1.sysT);
        }
    }

    private static class SysTimeComparator
    implements Comparator<ThreadLine> {
        private SysTimeComparator() {
        }

        @Override
        public int compare(ThreadLine o1, ThreadLine o2) {
            return Double.compare(o2.sysT, o1.sysT);
        }
    }

    private static class UserTimeComparator
    implements Comparator<ThreadLine> {
        private UserTimeComparator() {
        }

        @Override
        public int compare(ThreadLine o1, ThreadLine o2) {
            return Double.compare(o2.userT, o1.userT);
        }
    }

    private static class ThreadLine {
        long id;
        String name;
        double userT;
        double sysT;
        double allocRate;
        double waitRate;
        double waitT;
        double blockRate;
        double blockT;

        public ThreadLine(long id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return String.format("[%06d] user=%5.2f%% sys=%5.2f%% - %s", this.id, this.userT, this.sysT, this.name);
        }
    }

    private static class ThreadNote {
        private long lastCpuTime;
        private long lastUserTime;
        private long lastAllocatedBytes;
        private long lastWaitCount;
        private long lastWaitTime;
        private long lastBlockCount;
        private long lastBlockTime;

        private ThreadNote() {
        }
    }

    private static class ThreadTrac {
        private String name;
        private long lastCpuTime;
        private long lastUserTime;
        private long lastAllocatedBytes;
        private ThreadInfo lastThreadInfo;
        private boolean dead;

        private ThreadTrac() {
        }
    }
}

