/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.output.hg.task;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.output.hg.metrics.LoadMetrics;
import org.apache.hugegraph.computer.core.output.hg.metrics.LoadSummary;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.structure.graph.Vertex;

public abstract class InsertTask
implements Runnable {
    public static final Set<String> UNACCEPTABLE_EXCEPTIONS = ImmutableSet.of((Object)"class java.lang.IllegalArgumentException");
    public static final String[] UNACCEPTABLE_MESSAGES = new String[]{"Connection refused", "The server is being shutting down", "not allowed to insert, because already exist a vertex with same id and different label"};
    protected Config config;
    private HugeClient client;
    protected final List<Vertex> batch;
    private LoadSummary summary;

    public InsertTask(Config config, HugeClient client, List<Vertex> batch, LoadSummary loadSummary) {
        this.config = config;
        this.client = client;
        this.batch = batch;
        this.summary = loadSummary;
    }

    public LoadSummary summary() {
        return this.summary;
    }

    public LoadMetrics metrics() {
        return this.summary().metrics();
    }

    protected void plusLoadSuccess(int count) {
        LoadMetrics metrics = this.summary().metrics();
        metrics.plusInsertSuccess(count);
        this.summary().plusLoaded(count);
    }

    protected void increaseLoadSuccess() {
        this.plusLoadSuccess(1);
    }

    protected void insertBatch(List<Vertex> vertices) {
        this.client.graph().addVertices(vertices);
    }
}

