/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian;

import com.alipay.hessian.ClassNameFilter;
import com.alipay.hessian.clhm.ConcurrentLinkedHashMap;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public class NameBlackListFilter
implements ClassNameFilter {
    protected static List<String> blackPrefixList;
    protected static ConcurrentMap<String, Boolean> resultOfInBlackList;

    public NameBlackListFilter(List<String> blackPrefixList) {
        this(blackPrefixList, 8192);
    }

    public NameBlackListFilter(List<String> blackPrefixList, int maxCacheSize) {
        NameBlackListFilter.blackPrefixList = blackPrefixList;
        NameBlackListFilter.buildCache(blackPrefixList, maxCacheSize);
    }

    public static void buildCache(List<String> blackPrefixList, int maxCacheSize) {
        if (blackPrefixList != null && !blackPrefixList.isEmpty()) {
            NameBlackListFilter.blackPrefixList = blackPrefixList;
            int min = Math.min(256, maxCacheSize);
            int max = Math.min(10240, maxCacheSize);
            ConcurrentLinkedHashMap.Builder builder = new ConcurrentLinkedHashMap.Builder().initialCapacity(min).maximumWeightedCapacity(max);
            resultOfInBlackList = builder.build();
        } else {
            resultOfInBlackList = null;
        }
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public String resolve(String className) throws IOException {
        if (blackPrefixList == null || resultOfInBlackList == null) {
            return className;
        }
        Boolean result = (Boolean)resultOfInBlackList.get(className);
        if (result == null) {
            result = this.inBlackList(className);
            resultOfInBlackList.putIfAbsent(className, result);
        }
        if (result.booleanValue()) {
            throw new IOException("Class " + className + " is in blacklist. ");
        }
        return className;
    }

    protected boolean inBlackList(String className) {
        for (String prefix : blackPrefixList) {
            if (!className.startsWith(prefix)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

