/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.hugegraph.concurrent.PausableScheduledThreadPool;

public final class ExecutorUtil {
    public static ExecutorService newFixedThreadPool(String name) {
        return ExecutorUtil.newFixedThreadPool(1, name);
    }

    public static ExecutorService newFixedThreadPool(int size, String name) {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern(name).build();
        return Executors.newFixedThreadPool(size, factory);
    }

    public static ScheduledExecutorService newScheduledThreadPool(String name) {
        return ExecutorUtil.newScheduledThreadPool(1, name);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int size, String name) {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern(name).build();
        return Executors.newScheduledThreadPool(size, factory);
    }

    public static PausableScheduledThreadPool newPausableScheduledThreadPool(String name) {
        return ExecutorUtil.newPausableScheduledThreadPool(1, name);
    }

    public static PausableScheduledThreadPool newPausableScheduledThreadPool(int size, String name) {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern(name).build();
        return new PausableScheduledThreadPool(size, factory);
    }
}

