/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.traverser;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.structure.traverser.RepeatEdgeStep;
import org.apache.hugegraph.structure.traverser.VerticesArgs;
import org.apache.hugegraph.util.E;

public class TemplatePathsRequest {
    @JsonProperty(value="sources")
    private VerticesArgs sources = null;
    @JsonProperty(value="targets")
    private VerticesArgs targets = null;
    @JsonProperty(value="steps")
    public List<RepeatEdgeStep> steps = new ArrayList<RepeatEdgeStep>();
    @JsonProperty(value="with_ring")
    public boolean withRing = false;
    @JsonProperty(value="capacity")
    public long capacity = 10000000L;
    @JsonProperty(value="limit")
    public int limit = 10;
    @JsonProperty(value="with_vertex")
    public boolean withVertex = false;

    private TemplatePathsRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("TemplatePathsRequest{sources=%s,targets=%s,steps=%s,withRing=%s,capacity=%s,limit=%s,withVertex=%s}", this.sources, this.targets, this.steps, this.withRing, this.capacity, this.limit, this.withVertex);
    }

    public static class Builder {
        private TemplatePathsRequest request = new TemplatePathsRequest();
        private VerticesArgs.Builder sourcesBuilder = VerticesArgs.builder();
        private VerticesArgs.Builder targetsBuilder = VerticesArgs.builder();
        private List<RepeatEdgeStep.Builder> stepBuilders = new ArrayList<RepeatEdgeStep.Builder>();

        private Builder() {
        }

        public VerticesArgs.Builder sources() {
            return this.sourcesBuilder;
        }

        public VerticesArgs.Builder targets() {
            return this.targetsBuilder;
        }

        public RepeatEdgeStep.Builder steps() {
            RepeatEdgeStep.Builder builder = RepeatEdgeStep.repeatStepBuilder();
            this.stepBuilders.add(builder);
            return builder;
        }

        public Builder withRing(boolean withRing) {
            this.request.withRing = withRing;
            return this;
        }

        public Builder capacity(long capacity) {
            TraversersAPI.checkCapacity(capacity);
            this.request.capacity = capacity;
            return this;
        }

        public Builder limit(int limit) {
            TraversersAPI.checkLimit(limit);
            this.request.limit = limit;
            return this;
        }

        public Builder withVertex(boolean withVertex) {
            this.request.withVertex = withVertex;
            return this;
        }

        public TemplatePathsRequest build() {
            this.request.sources = this.sourcesBuilder.build();
            E.checkArgument(this.request.sources != null, "Source vertices can't be null", new Object[0]);
            this.request.targets = this.targetsBuilder.build();
            E.checkArgument(this.request.targets != null, "Target vertices can't be null", new Object[0]);
            for (RepeatEdgeStep.Builder builder : this.stepBuilders) {
                this.request.steps.add(builder.build());
            }
            E.checkArgument(this.request.steps != null && !this.request.steps.isEmpty(), "The steps can't be null or empty", new Object[0]);
            TraversersAPI.checkCapacity(this.request.capacity);
            TraversersAPI.checkLimit(this.request.limit);
            return this.request;
        }
    }
}

