/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.traverser;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.structure.traverser.EdgeStep;
import org.apache.hugegraph.util.E;

public class SingleSourceJaccardSimilarityRequest {
    @JsonProperty(value="vertex")
    private Object vertex = null;
    @JsonProperty(value="step")
    public EdgeStep step = null;
    @JsonProperty(value="top")
    public int top = 10;
    @JsonProperty(value="capacity")
    public long capacity = 10000000L;

    private SingleSourceJaccardSimilarityRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("SingleSourceJaccardSimilarityRequest{vertex=%s,step=%s,top=%s,capacity=%s}", this.vertex, this.step, this.top, this.capacity);
    }

    public static class Builder {
        private SingleSourceJaccardSimilarityRequest request = new SingleSourceJaccardSimilarityRequest();
        private EdgeStep.Builder stepBuilder = EdgeStep.builder();

        private Builder() {
        }

        public Builder vertex(Object vertex) {
            E.checkNotNull(vertex, "vertex");
            this.request.vertex = vertex;
            return this;
        }

        public EdgeStep.Builder step() {
            EdgeStep.Builder builder;
            this.stepBuilder = builder = EdgeStep.builder();
            return builder;
        }

        public Builder top(int top) {
            TraversersAPI.checkPositive(top, "top");
            this.request.top = top;
            return this;
        }

        public Builder capacity(long capacity) {
            TraversersAPI.checkCapacity(capacity);
            this.request.capacity = capacity;
            return this;
        }

        public SingleSourceJaccardSimilarityRequest build() {
            E.checkArgument(this.request.vertex != null, "The vertex can't be null", new Object[0]);
            this.request.step = this.stepBuilder.build();
            E.checkNotNull(this.request.step, "step");
            TraversersAPI.checkCapacity(this.request.capacity);
            E.checkArgument(this.request.top >= 0, "The top must be >= 0, but got: %s", this.request.top);
            return this.request;
        }
    }
}

