/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.operator.controller;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.k8s.Constants;
import org.apache.hugegraph.computer.k8s.crd.model.ComputerJobSpec;
import org.apache.hugegraph.computer.k8s.crd.model.HugeGraphComputerJob;
import org.apache.hugegraph.computer.k8s.crd.model.ResourceName;
import org.apache.hugegraph.computer.k8s.operator.config.OperatorOptions;
import org.apache.hugegraph.computer.k8s.operator.controller.ComputerJobComponent;
import org.apache.hugegraph.computer.k8s.util.KubeUtil;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class ComputerJobDeployer {
    private static final Logger LOG = Log.logger(ComputerJobDeployer.class);
    private final NamespacedKubernetesClient kubeClient;
    private static final int JOB_BACKOFF_LIMIT = 0;
    private static final String JOB_RESTART_POLICY = "Never";
    private static final String TOPOLOGY_KEY = "kubernetes.io/hostname";
    private static final String SCHEDULE_ANYWAY = "ScheduleAnyway";
    private static final Integer MAX_SKEW = 1;
    private static final String RANDOM_PORT = "0";
    private static final String PROTOCOL = "TCP";
    private static final String TRANSPORT_PORT_NAME = "transport-port";
    private static final String RPC_PORT_NAME = "rpc-port";
    private static final int DEFAULT_TRANSPORT_PORT = 8099;
    private static final int DEFAULT_RPC_PORT = 8190;
    private static final String COMPUTER_CONFIG_MAP_VOLUME = "computer-config-map-volume";
    private static final String POD_IP_KEY = "status.podIP";
    private static final String POD_NAMESPACE_KEY = "metadata.namespace";
    private static final String POD_NAME_KEY = "metadata.name";
    private static final Long TERMINATION_GRACE_PERIOD = 180L;
    private final String internalEtcdUrl;
    private final String timezone;

    public ComputerJobDeployer(NamespacedKubernetesClient kubeClient, HugeConfig config) {
        this.kubeClient = kubeClient;
        this.internalEtcdUrl = (String)config.get(OperatorOptions.INTERNAL_ETCD_URL);
        this.timezone = (String)config.get(OperatorOptions.TIMEZONE);
    }

    public void deploy(ComputerJobComponent observed) {
        HugeGraphComputerJob computerJob = observed.computerJob();
        Set<ContainerPort> ports = this.handleConfig((ComputerJobSpec)computerJob.getSpec());
        ComputerJobComponent desired = new ComputerJobComponent();
        desired.configMap(this.desiredConfigMap(computerJob));
        desired.masterJob(this.desiredMasterJob(computerJob, ports));
        desired.workerJob(this.desiredWorkerJob(computerJob, ports));
        this.reconcileComponent(computerJob.getMetadata().getNamespace(), desired, observed);
    }

    private void reconcileComponent(String namespace, ComputerJobComponent desired, ComputerJobComponent observed) {
        ConfigMap desiredConfigMap = desired.configMap();
        ConfigMap observedConfigMap = observed.configMap();
        KubernetesClient client = !Objects.equals(this.kubeClient.getNamespace(), namespace) ? (KubernetesClient)this.kubeClient.inNamespace(namespace) : this.kubeClient;
        if (desiredConfigMap == null && observedConfigMap != null) {
            client.configMaps().delete(observedConfigMap);
        } else if (desiredConfigMap != null && observedConfigMap == null) {
            KubeUtil.ignoreExists(() -> (ConfigMap)client.configMaps().create(desiredConfigMap));
        }
        if (desiredConfigMap != null && observedConfigMap != null) {
            LOG.debug("ConfigMap already exists, no action");
        }
        Job desiredMasterJob = desired.masterJob();
        Job observedMasterJob = observed.masterJob();
        if (desiredMasterJob == null && observedMasterJob != null) {
            client.batch().v1().jobs().delete(observedMasterJob);
        } else if (desiredMasterJob != null && observedMasterJob == null) {
            KubeUtil.ignoreExists(() -> (Job)client.batch().v1().jobs().create(desiredMasterJob));
        }
        if (desiredMasterJob != null && observedMasterJob != null) {
            LOG.debug("MasterJob already exists, no action");
        }
        Job desiredWorkerJob = desired.workerJob();
        Job observedWorkerJob = observed.workerJob();
        if (desiredWorkerJob == null && observedWorkerJob != null) {
            client.batch().v1().jobs().delete(observedWorkerJob);
        } else if (desiredWorkerJob != null && observedWorkerJob == null) {
            KubeUtil.ignoreExists(() -> (Job)client.batch().v1().jobs().create(desiredWorkerJob));
        }
        if (desiredWorkerJob != null && observedWorkerJob != null) {
            LOG.debug("WorkerJob already exists, no action");
        }
    }

    private Set<ContainerPort> handleConfig(ComputerJobSpec spec) {
        Map<String, String> config = spec.getComputerConf();
        config.put(ComputerOptions.JOB_ID.name(), String.valueOf(spec.getJobId()));
        config.put(ComputerOptions.JOB_WORKERS_COUNT.name(), String.valueOf(spec.getWorkerInstances()));
        String ip = String.format("${%s}", "POD_IP");
        config.put(ComputerOptions.TRANSPORT_SERVER_HOST.name(), ip);
        config.put("rpc.server_host", ip);
        config.putIfAbsent(ComputerOptions.BSP_ETCD_ENDPOINTS.name(), this.internalEtcdUrl);
        String transportPort = config.get(ComputerOptions.TRANSPORT_SERVER_PORT.name());
        if (StringUtils.isBlank(transportPort) || RANDOM_PORT.equals(transportPort)) {
            transportPort = String.valueOf(8099);
            config.put(ComputerOptions.TRANSPORT_SERVER_PORT.name(), transportPort);
        }
        ContainerPort transportContainerPort = ((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName(TRANSPORT_PORT_NAME)).withContainerPort(Integer.valueOf(transportPort))).withProtocol(PROTOCOL)).build();
        String rpcPort = config.get("rpc.server_port");
        if (StringUtils.isBlank(rpcPort) || RANDOM_PORT.equals(rpcPort)) {
            rpcPort = String.valueOf(8190);
            config.put("rpc.server_port", rpcPort);
        }
        ContainerPort rpcContainerPort = ((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName(RPC_PORT_NAME)).withContainerPort(Integer.valueOf(rpcPort))).withProtocol(PROTOCOL)).build();
        return Sets.newHashSet(transportContainerPort, rpcContainerPort);
    }

    private ConfigMap desiredConfigMap(HugeGraphComputerJob computerJob) {
        String crName = computerJob.getMetadata().getName();
        ComputerJobSpec spec = (ComputerJobSpec)computerJob.getSpec();
        Map<String, String> computerConf = spec.getComputerConf();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("computer.properties", KubeUtil.asProperties(computerConf));
        String log4jXml = spec.getLog4jXml();
        if (StringUtils.isNotBlank(log4jXml)) {
            data.put("log4j2.xml", log4jXml);
        }
        String name = KubeUtil.configMapName(crName);
        return ((ConfigMapBuilder)((ConfigMapBuilder)new ConfigMapBuilder().withMetadata(this.getMetadata(computerJob, name))).withData(data)).build();
    }

    public Job desiredMasterJob(HugeGraphComputerJob computerJob, Set<ContainerPort> ports) {
        List<String> args;
        String crName = computerJob.getMetadata().getName();
        String namespace = computerJob.getMetadata().getNamespace();
        ComputerJobSpec spec = (ComputerJobSpec)computerJob.getSpec();
        List<String> command = spec.getMasterCommand();
        if (CollectionUtils.isEmpty(command)) {
            command = Constants.COMMAND;
        }
        if (CollectionUtils.isEmpty(args = spec.getMasterArgs())) {
            args = Constants.MASTER_ARGS;
        }
        String name = KubeUtil.masterJobName(crName);
        ObjectMeta metadata = this.getMetadata(computerJob, name);
        Container container = this.getContainer(name, namespace, spec, ports, command, args);
        ArrayList<Container> containers = Lists.newArrayList(container);
        boolean instances = true;
        return this.getJob(crName, metadata, spec, 1, containers);
    }

    public Job desiredWorkerJob(HugeGraphComputerJob computerJob, Set<ContainerPort> ports) {
        List<String> args;
        String crName = computerJob.getMetadata().getName();
        String namespace = computerJob.getMetadata().getNamespace();
        ComputerJobSpec spec = (ComputerJobSpec)computerJob.getSpec();
        List<String> command = spec.getWorkerCommand();
        if (CollectionUtils.isEmpty(command)) {
            command = Constants.COMMAND;
        }
        if (CollectionUtils.isEmpty(args = spec.getWorkerArgs())) {
            args = Constants.WORKER_ARGS;
        }
        String name = KubeUtil.workerJobName(crName);
        ObjectMeta metadata = this.getMetadata(computerJob, name);
        Container container = this.getContainer(name, namespace, spec, ports, command, args);
        ArrayList<Container> containers = Lists.newArrayList(container);
        int instances = spec.getWorkerInstances();
        return this.getJob(crName, metadata, spec, instances, containers);
    }

    private Job getJob(String crName, ObjectMeta meta, ComputerJobSpec spec, int instances, List<Container> containers) {
        List<Volume> volumes = spec.getVolumes();
        volumes = volumes == null ? new ArrayList<Volume>() : Lists.newArrayList(volumes);
        volumes.addAll(this.getConfigMapAndSecretVolumes(spec));
        String configMapName = KubeUtil.configMapName(crName);
        Volume configVolume = this.getComputerConfigVolume(configMapName);
        volumes.add(configVolume);
        PodTemplateSpec podTemplateSpec = spec.getPodTemplateSpec();
        podTemplateSpec = podTemplateSpec == null ? new PodTemplateSpec() : Serialization.clone(podTemplateSpec);
        ObjectMeta metadata = podTemplateSpec.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
        }
        metadata = ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder(metadata).addToLabels(meta.getLabels())).addToAnnotations(meta.getAnnotations())).build();
        podTemplateSpec.setMetadata(metadata);
        PodSpec podSpec = podTemplateSpec.getSpec();
        if (podSpec == null) {
            podSpec = new PodSpec();
        }
        podSpec.setVolumes(volumes);
        podSpec.setContainers(containers);
        podSpec.setRestartPolicy(JOB_RESTART_POLICY);
        if (podSpec.getTerminationGracePeriodSeconds() == null) {
            podSpec.setTerminationGracePeriodSeconds(TERMINATION_GRACE_PERIOD);
        }
        if (CollectionUtils.isEmpty(podSpec.getImagePullSecrets())) {
            podSpec.setImagePullSecrets(spec.getPullSecrets());
        }
        if (CollectionUtils.isEmpty(podSpec.getTopologySpreadConstraints())) {
            LabelSelector labelSelector = new LabelSelector();
            labelSelector.setMatchLabels(meta.getLabels());
            TopologySpreadConstraint spreadConstraint = new TopologySpreadConstraint(labelSelector, MAX_SKEW, TOPOLOGY_KEY, SCHEDULE_ANYWAY);
            podSpec.setTopologySpreadConstraints(Lists.newArrayList(spreadConstraint));
        }
        podTemplateSpec.setSpec(podSpec);
        return ((JobBuilder)((JobFluent.SpecNested)((JobFluent.SpecNested)((JobFluent.SpecNested)((JobFluent.SpecNested)((JobBuilder)new JobBuilder().withMetadata(meta)).withNewSpec().withParallelism(instances)).withCompletions(instances)).withBackoffLimit(0)).withTemplate(podTemplateSpec)).endSpec()).build();
    }

    private List<Volume> getConfigMapAndSecretVolumes(ComputerJobSpec spec) {
        Map<String, String> secretPaths;
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        Map<String, String> configMapPaths = spec.getConfigMapPaths();
        if (MapUtils.isNotEmpty(configMapPaths)) {
            Set<String> configMapNames = configMapPaths.keySet();
            for (String configMapName : configMapNames) {
                Volume volume = ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName(this.volumeName(configMapName))).withNewConfigMap().withName(configMapName)).endConfigMap()).build();
                volumes.add(volume);
            }
        }
        if (MapUtils.isNotEmpty(secretPaths = spec.getSecretPaths())) {
            Set<String> secretNames = secretPaths.keySet();
            for (String secretName : secretNames) {
                Volume volume = ((VolumeBuilder)((VolumeFluent.SecretNested)((VolumeBuilder)new VolumeBuilder().withName(this.volumeName(secretName))).withNewSecret().withSecretName(secretName)).endSecret()).build();
                volumes.add(volume);
            }
        }
        return volumes;
    }

    private Container getContainer(String name, String namespace, ComputerJobSpec spec, Set<ContainerPort> ports, Collection<String> command, Collection<String> args) {
        Map<String, String> secretPaths;
        List<VolumeMount> volumeMounts;
        Quantity memory;
        Quantity cpu;
        String jvmOptions;
        String remoteJarUri;
        String jarFile;
        List<EnvVar> envVars = spec.getEnvVars();
        if (envVars == null) {
            envVars = new ArrayList<EnvVar>();
        }
        EnvVar podIP = ((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.FieldRefNested)((EnvVarBuilder)new EnvVarBuilder().withName("POD_IP")).withNewValueFrom().withNewFieldRef().withFieldPath(POD_IP_KEY)).endFieldRef()).endValueFrom()).build();
        envVars.add(podIP);
        EnvVar podName = ((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.FieldRefNested)((EnvVarBuilder)new EnvVarBuilder().withName("POD_NAME")).withNewValueFrom().withNewFieldRef().withFieldPath(POD_NAME_KEY)).endFieldRef()).endValueFrom()).build();
        envVars.add(podName);
        EnvVar podNamespace = ((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.FieldRefNested)((EnvVarBuilder)new EnvVarBuilder().withName("POD_NAMESPACE")).withNewValueFrom().withNewFieldRef().withFieldPath(POD_NAMESPACE_KEY)).endFieldRef()).endValueFrom()).build();
        envVars.add(podNamespace);
        EnvVar confDir = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("CONFIG_DIR")).withValue("/opt/hugegraph-computer/conf")).build();
        envVars.add(confDir);
        EnvVar confPath = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("COMPUTER_CONF_PATH")).withValue(Constants.COMPUTER_CONF_PATH)).build();
        envVars.add(confPath);
        String log4jXml = spec.getLog4jXml();
        if (StringUtils.isNotBlank(log4jXml)) {
            EnvVar logConfEnv = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("LOG4J_CONF_PATH")).withValue(Constants.LOG_XML_PATH)).build();
            envVars.add(logConfEnv);
        }
        if (StringUtils.isNotBlank(jarFile = spec.getJarFile())) {
            EnvVar jarFilePath = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("JAR_FILE_PATH")).withValue(jarFile)).build();
            envVars.add(jarFilePath);
        }
        if (StringUtils.isNotBlank(remoteJarUri = spec.getRemoteJarUri())) {
            EnvVar jobJarURI = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("REMOTE_JAR_URI")).withValue(remoteJarUri)).build();
            envVars.add(jobJarURI);
        }
        StringBuilder jvmOptionsBuilder = (jvmOptions = spec.getJvmOptions()) == null ? new StringBuilder() : new StringBuilder(jvmOptions.trim());
        jvmOptionsBuilder.append(" ").append("-Duser.timezone=").append(this.timezone);
        EnvVar jvmOptionsEnv = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("JVM_OPTIONS")).withValue(jvmOptionsBuilder.toString().trim())).build();
        envVars.add(jvmOptionsEnv);
        if (name.contains("master")) {
            cpu = spec.getMasterCpu();
            memory = spec.getMasterMemory();
        } else {
            cpu = spec.getWorkerCpu();
            memory = spec.getWorkerMemory();
        }
        if (cpu != null) {
            EnvVar cpuLimit = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("CPU_LIMIT")).withValue(cpu.toString())).build();
            envVars.add(cpuLimit);
        }
        if (memory != null) {
            EnvVar memoryLimit = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("MEMORY_LIMIT")).withValue(memory.toString())).build();
            envVars.add(memoryLimit);
        }
        volumeMounts = (volumeMounts = spec.getVolumeMounts()) == null ? new ArrayList<VolumeMount>() : Lists.newArrayList(volumeMounts);
        KubernetesClient client = !Objects.equals(this.kubeClient.getNamespace(), namespace) ? (KubernetesClient)this.kubeClient.inNamespace(namespace) : this.kubeClient;
        Map<String, String> configMapPaths = spec.getConfigMapPaths();
        if (MapUtils.isNotEmpty(configMapPaths)) {
            for (String string : configMapPaths.keySet()) {
                ConfigMap configMap = (ConfigMap)((Resource)client.configMaps().withName(string)).get();
                E.checkArgument(configMap != null && configMap.getData().size() > 0, "The configMap '%s' don't exist", string);
                this.mountConfigMapOrSecret(volumeMounts, string, configMapPaths.get(string), configMap.getData());
            }
        }
        if (MapUtils.isNotEmpty(secretPaths = spec.getSecretPaths())) {
            for (String key : secretPaths.keySet()) {
                Secret secret = (Secret)((Resource)client.secrets().withName(key)).get();
                E.checkArgument(secret != null && secret.getData().size() > 0, "The secret '%s' don't exist", key);
                this.mountConfigMapOrSecret(volumeMounts, key, secretPaths.get(key), secret.getData());
            }
        }
        VolumeMount volumeMount = this.getComputerConfigMount();
        volumeMounts.add(volumeMount);
        Container container = ((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluent.ResourcesNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(KubeUtil.containerName(name))).withImage(spec.getImage())).withImagePullPolicy(spec.getPullPolicy())).withEnv(spec.getEnvVars())).withEnvFrom(spec.getEnvFrom())).withVolumeMounts(volumeMounts)).addAllToCommand(command)).addAllToArgs(args)).addAllToPorts(ports)).withNewResources().addToLimits(ResourceName.CPU.value(), cpu)).addToLimits(ResourceName.MEMORY.value(), memory)).endResources()).build();
        if (spec.getSecurityContext() != null) {
            container.setSecurityContext(spec.getSecurityContext());
        }
        return container;
    }

    private void mountConfigMapOrSecret(List<VolumeMount> volumeMounts, String key, String volumePath, Map<String, String> data) {
        VolumeMountBuilder volumeMountBuilder = (VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(this.volumeName(key))).withMountPath(volumePath);
        if (data.size() == 1) {
            String fileName = data.keySet().stream().findFirst().orElse("");
            volumeMountBuilder.withMountPath(Paths.get(volumePath, fileName).toString());
            volumeMountBuilder.withSubPath(fileName);
        }
        volumeMounts.add(volumeMountBuilder.build());
    }

    private VolumeMount getComputerConfigMount() {
        return ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(COMPUTER_CONFIG_MAP_VOLUME)).withMountPath("/opt/hugegraph-computer/conf")).build();
    }

    private Volume getComputerConfigVolume(String configMapName) {
        return ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName(COMPUTER_CONFIG_MAP_VOLUME)).withNewConfigMap().withName(configMapName)).endConfigMap()).build();
    }

    public ObjectMeta getMetadata(HugeGraphComputerJob computerJob, String component) {
        String namespace = computerJob.getMetadata().getNamespace();
        String crName = computerJob.getMetadata().getName();
        OwnerReference ownerReference = ((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)new OwnerReferenceBuilder().withName(crName)).withApiVersion(computerJob.getApiVersion())).withUid(computerJob.getMetadata().getUid())).withKind(computerJob.getKind())).withController(true)).withBlockOwnerDeletion(true)).build();
        String kind = HasMetadata.getKind(HugeGraphComputerJob.class);
        Map<String, String> labels = KubeUtil.commonLabels(kind, crName, component);
        return ((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withNamespace(namespace)).withName(component)).addToLabels(labels)).withOwnerReferences(ownerReference)).build();
    }

    private String volumeName(String name) {
        return name + "-volume";
    }
}

