/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.operator.common;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class WorkQueue<T> {
    private final LinkedList<T> queue = new LinkedList();
    private final Set<T> incoming = new HashSet<T>();
    private final Set<T> processing = new HashSet<T>();
    private boolean shutdown;

    public synchronized void add(T item) {
        if (this.shutdown) {
            return;
        }
        if (this.incoming.contains(item)) {
            return;
        }
        this.incoming.add(item);
        if (this.processing.contains(item)) {
            return;
        }
        this.queue.add(item);
        this.notify();
    }

    public synchronized int length() {
        return this.queue.size();
    }

    public synchronized T get() throws InterruptedException {
        while (this.queue.size() == 0) {
            if (this.shutdown) {
                return null;
            }
            this.wait();
        }
        T obj = this.queue.poll();
        this.processing.add(obj);
        this.incoming.remove(obj);
        return obj;
    }

    public synchronized void done(T item) {
        this.processing.remove(item);
        if (this.incoming.contains(item)) {
            this.queue.add(item);
            this.notify();
        }
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.notifyAll();
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }
}

