/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.crd.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ResourceName {
    CPU("cpu"),
    MEMORY("memory"),
    STORAGE("storage"),
    EPHEMERAL_STORAGE("ephemeral-storage");

    private final String value;
    private static final Map<String, ResourceName> CONSTANTS;

    private ResourceName(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ResourceName fromValue(String value) {
        ResourceName constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ResourceName>();
        for (ResourceName c : ResourceName.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

