/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.output.hg.task;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.output.hg.metrics.LoadSummary;
import org.apache.hugegraph.computer.core.output.hg.task.InsertTask;
import org.apache.hugegraph.computer.core.output.hg.task.TaskManager;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class BatchInsertTask
extends InsertTask {
    private static final Logger LOG = Log.logger(TaskManager.class);

    public BatchInsertTask(Config config, HugeClient client, List<Vertex> batch, LoadSummary loadSummary) {
        super(config, client, batch, loadSummary);
    }

    @Override
    public void run() {
        int retryCount = 0;
        int retryTimes = (Integer)this.config.get(ComputerOptions.OUTPUT_RETRY_TIMES);
        do {
            try {
                this.insertBatch(this.batch);
                break;
            }
            catch (ClientException e) {
                LOG.debug("client exception: {}", (Object)e.getMessage());
                Throwable cause = e.getCause();
                if (cause != null && cause.getMessage() != null && StringUtils.containsAny((CharSequence)cause.getMessage(), UNACCEPTABLE_MESSAGES)) {
                    throw e;
                }
                retryCount = this.waitThenRetry(retryCount, e);
            }
            catch (ServerException e) {
                String message = e.getMessage();
                LOG.error("server exception: {}", (Object)message);
                if (UNACCEPTABLE_EXCEPTIONS.contains(e.exception())) {
                    throw e;
                }
                if (StringUtils.containsAny((CharSequence)message, UNACCEPTABLE_MESSAGES)) {
                    throw e;
                }
                retryCount = this.waitThenRetry(retryCount, e);
            }
        } while (retryCount > 0 && retryCount <= retryTimes);
        int count = this.batch.size();
        this.plusLoadSuccess(count);
    }

    private int waitThenRetry(int retryCount, RuntimeException e) {
        int retryTimes = (Integer)this.config.get(ComputerOptions.OUTPUT_RETRY_TIMES);
        if (retryTimes <= 0) {
            return retryCount;
        }
        if (++retryCount > retryTimes) {
            LOG.error("Batch insert has been retried more than {} times", (Object)retryTimes);
            throw e;
        }
        long interval = (1L << retryCount) * (long)((Integer)this.config.get(ComputerOptions.OUTPUT_RETRY_INTERVAL)).intValue();
        LOG.debug("Batch insert will sleep {} seconds then do the {}th retry", (Object)interval, (Object)retryCount);
        try {
            Thread.sleep(interval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return retryCount;
    }
}

