/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.value;

import java.io.IOException;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.util.E;

public class LongValue
extends Number
implements Value.Tvalue<Long> {
    private static final long serialVersionUID = 8332327679205404212L;
    private long value;

    public LongValue() {
        this(0L);
    }

    public LongValue(long value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Long value() {
        return this.value;
    }

    public void value(long value) {
        this.value = value;
    }

    @Override
    public ValueType valueType() {
        return ValueType.LONG;
    }

    @Override
    public void assign(Value other) {
        this.checkAssign(other);
        this.value = ((LongValue)other).value;
    }

    @Override
    public LongValue copy() {
        return new LongValue(this.value);
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public void read(RandomAccessInput in) throws IOException {
        this.value = in.readLong();
    }

    @Override
    public void write(RandomAccessOutput out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    public int compareTo(Value obj) {
        E.checkArgumentNotNull(obj, "The compare argument can't be null", new Object[0]);
        int typeDiff = this.valueType().compareTo(obj.valueType());
        if (typeDiff != 0) {
            return typeDiff;
        }
        return Long.compare(this.value, ((LongValue)obj).value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongValue)) {
            return false;
        }
        return ((LongValue)obj).value == this.value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

