/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.value;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.SerialEnum;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.util.E;

public class ListValue<T extends Value.Tvalue<?>>
implements Value.Tvalue<List<Object>> {
    private final GraphFactory graphFactory;
    private ValueType elemType;
    private List<T> values;

    public ListValue() {
        this(ValueType.UNKNOWN);
    }

    public ListValue(ValueType elemType) {
        this(elemType, new ArrayList());
    }

    public ListValue(ValueType elemType, List<T> values) {
        this.elemType = elemType;
        this.values = values;
        this.graphFactory = ComputerContext.instance().graphFactory();
    }

    public void checkAndSetType(T value) {
        E.checkArgument(value != null, "Can't add null to %s", this.valueType().string());
        if (this.elemType != ValueType.UNKNOWN) {
            E.checkArgument(this.elemType == value.valueType(), "Invalid value '%s' with type %s, expect element with type %s", value, value.valueType().string(), this.elemType.string());
        } else {
            this.elemType = value.valueType();
        }
    }

    public void add(T value) {
        this.checkAndSetType(value);
        this.values.add(value);
    }

    public void addAll(Collection<T> values) {
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        Iterator<T> iterator = values.iterator();
        Value.Tvalue firstValue = (Value.Tvalue)iterator.next();
        this.checkAndSetType(firstValue);
        this.values.addAll(values);
    }

    public T get(int index) {
        return (T)((Value.Tvalue)this.values.get(index));
    }

    public T getLast() {
        int index = this.values.size() - 1;
        if (index < 0) {
            throw new NoSuchElementException("The list is empty");
        }
        return (T)((Value.Tvalue)this.values.get(index));
    }

    public boolean contains(T obj) {
        return this.values.contains(obj);
    }

    public List<T> values() {
        return Collections.unmodifiableList(this.values);
    }

    public int size() {
        return this.values.size();
    }

    @Override
    public List<Object> value() {
        ArrayList<Object> list = new ArrayList<Object>(this.values.size());
        for (Value.Tvalue value : this.values) {
            list.add(value.value());
        }
        return list;
    }

    @Override
    public ValueType valueType() {
        return ValueType.LIST_VALUE;
    }

    public ValueType elemType() {
        return this.elemType;
    }

    @Override
    public void assign(Value other) {
        this.checkAssign(other);
        ValueType elemType = ((ListValue)other).elemType();
        E.checkArgument(elemType == this.elemType(), "Can't assign %s<%s> to %s<%s>", other.valueType().string(), elemType.string(), this.valueType().string(), this.elemType().string());
        this.values = ((ListValue)other).values();
    }

    @Override
    public ListValue<T> copy() {
        List values = this.graphFactory.createList();
        for (Value.Tvalue value : this.values) {
            values.add((Value.Tvalue)value.copy());
        }
        return new ListValue(this.elemType, values);
    }

    @Override
    public void read(RandomAccessInput in) throws IOException {
        this.read(in, true);
    }

    protected void read(RandomAccessInput in, boolean readElemType) throws IOException {
        int size = in.readInt();
        if (readElemType) {
            this.elemType = SerialEnum.fromCode(ValueType.class, in.readByte());
        }
        if (size > this.values.size() || size < this.values.size() / 2) {
            this.values = this.graphFactory.createList(size);
        } else {
            this.values.clear();
        }
        for (int i = 0; i < size; ++i) {
            Value.Tvalue value = (Value.Tvalue)this.graphFactory.createValue(this.elemType);
            value.read(in);
            this.values.add(value);
        }
    }

    @Override
    public void write(RandomAccessOutput out) throws IOException {
        this.write(out, true);
    }

    protected void write(RandomAccessOutput out, boolean writeElemType) throws IOException {
        out.writeInt(this.values.size());
        if (writeElemType) {
            out.writeByte(this.elemType.code());
        }
        for (Value.Tvalue value : this.values) {
            value.write(out);
        }
    }

    @Override
    public int compareTo(Value obj) {
        E.checkArgumentNotNull(obj, "The compare argument can't be null", new Object[0]);
        int typeDiff = this.valueType().compareTo(obj.valueType());
        if (typeDiff != 0) {
            return typeDiff;
        }
        ListValue other = (ListValue)obj;
        int cmp = this.size() - other.size();
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 0; i < this.size(); ++i) {
            Value.Tvalue self = (Value.Tvalue)this.values.get(i);
            cmp = self.compareTo((Value)other.values.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListValue)) {
            return false;
        }
        ListValue other = (ListValue)obj;
        if (this.elemType != other.elemType) {
            return false;
        }
        return ListUtils.isEqualList(this.values, other.values);
    }

    public int hashCode() {
        return ListUtils.hashCodeForList(this.values);
    }

    public String toString() {
        return this.values.toString();
    }
}

