/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.metrics;

import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.util.CommonUtil;

public class MetricsAPI
extends API {
    public MetricsAPI(RestClient client) {
        super(client);
        this.path(this.type());
    }

    @Override
    protected String type() {
        return HugeType.METRICS.string();
    }

    public Map<String, Map<String, Object>> system() {
        RestResult result = this.client.get(this.path(), "system");
        Map map = result.readObject(Map.class);
        CommonUtil.checkMapClass(map, String.class, Map.class);
        for (Object mapValue : map.values()) {
            CommonUtil.checkMapClass(mapValue, String.class, Object.class);
        }
        return map;
    }

    public Map<String, Map<String, Object>> backend() {
        RestResult result = this.client.get(this.path(), "backend");
        Map map = result.readObject(Map.class);
        CommonUtil.checkMapClass(map, String.class, Map.class);
        for (Object mapValue : map.values()) {
            CommonUtil.checkMapClass(mapValue, String.class, Object.class);
        }
        return map;
    }

    public Map<String, Object> backend(String graph) {
        return this.backend().get(graph);
    }

    public Map<String, Map<String, Object>> all() {
        RestResult result = this.client.get(this.path());
        Map map = result.readObject(Map.class);
        CommonUtil.checkMapClass(map, String.class, Map.class);
        for (Object mapValue : map.values()) {
            CommonUtil.checkMapClass(mapValue, String.class, Object.class);
        }
        return map;
    }
}

